/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver;

import esa.commons.Checks;
import io.netty.handler.ssl.ClientAuth;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;

public class SslOptions
implements Serializable {
    private static final long serialVersionUID = 6772202423835136508L;
    private ClientAuth clientAuth;
    private String[] ciphers;
    private String[] enabledProtocols;
    private File certificate;
    private File privateKey;
    private String keyPassword;
    private File trustCertificates;
    private long sessionTimeout;
    private long sessionCacheSize;
    private long handshakeTimeoutMillis;

    public SslOptions() {
    }

    public SslOptions(SslOptions other) {
        Checks.checkNotNull((Object)other, (String)"other");
        this.clientAuth = other.clientAuth;
        this.ciphers = other.ciphers == null ? null : Arrays.copyOf(other.ciphers, other.ciphers.length);
        this.enabledProtocols = other.enabledProtocols == null ? null : Arrays.copyOf(other.enabledProtocols, other.enabledProtocols.length);
        this.certificate = other.certificate;
        this.privateKey = other.privateKey;
        this.keyPassword = other.keyPassword;
        this.trustCertificates = other.trustCertificates;
        this.sessionTimeout = other.sessionTimeout;
        this.sessionCacheSize = other.sessionCacheSize;
        this.handshakeTimeoutMillis = other.handshakeTimeoutMillis;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String[] getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String[] ciphers) {
        this.ciphers = ciphers;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public File getCertificate() {
        return this.certificate;
    }

    public void setCertificate(File certificate) {
        this.certificate = certificate;
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(File privateKey) {
        this.privateKey = privateKey;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public File getTrustCertificates() {
        return this.trustCertificates;
    }

    public void setTrustCertificates(File trustCertificates) {
        this.trustCertificates = trustCertificates;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public long getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setSessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeoutMillis(long handshakeTimeoutMillis) {
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }
}

