/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver;

import esa.httpserver.SslOptions;
import io.netty.handler.ssl.ClientAuth;
import java.io.File;

public final class SslOptionsConfigure {
    private ClientAuth clientAuth;
    private String[] ciphers;
    private String[] enabledProtocols;
    private File certificate;
    private File privateKey;
    private String keyPassword;
    private File trustCertificates;
    private long sessionTimeout;
    private long sessionCacheSize;
    private long handshakeTimeoutMillis;

    private SslOptionsConfigure() {
    }

    public static SslOptionsConfigure newOpts() {
        return new SslOptionsConfigure();
    }

    public SslOptionsConfigure clientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    public SslOptionsConfigure ciphers(String[] ciphers) {
        this.ciphers = ciphers;
        return this;
    }

    public SslOptionsConfigure enabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public SslOptionsConfigure certificate(File certificate) {
        this.certificate = certificate;
        return this;
    }

    public SslOptionsConfigure privateKey(File privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SslOptionsConfigure keyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public SslOptionsConfigure trustCertificates(File trustCertificates) {
        this.trustCertificates = trustCertificates;
        return this;
    }

    public SslOptionsConfigure sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public SslOptionsConfigure sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public SslOptionsConfigure handshakeTimeoutMillis(long handshakeTimeoutMillis) {
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
        return this;
    }

    public SslOptions configured() {
        SslOptions sslOptions = new SslOptions();
        sslOptions.setClientAuth(this.clientAuth);
        sslOptions.setCiphers(this.ciphers);
        sslOptions.setEnabledProtocols(this.enabledProtocols);
        sslOptions.setCertificate(this.certificate);
        sslOptions.setPrivateKey(this.privateKey);
        sslOptions.setKeyPassword(this.keyPassword);
        sslOptions.setTrustCertificates(this.trustCertificates);
        sslOptions.setSessionTimeout(this.sessionTimeout);
        sslOptions.setSessionCacheSize(this.sessionCacheSize);
        sslOptions.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        return sslOptions;
    }
}

