/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.StringUtils;
import esa.commons.http.HttpHeaders;
import esa.commons.http.HttpMethod;
import esa.commons.netty.http.CookieImpl;
import esa.httpserver.core.Aggregation;
import esa.httpserver.core.MultiPart;
import esa.httpserver.core.RequestHandle;
import esa.httpserver.impl.AggregationHandle;
import esa.httpserver.impl.BaseResponse;
import esa.httpserver.impl.MultipartHandle;
import esa.httpserver.impl.ServerRuntime;
import esa.httpserver.impl.Utils;
import esa.httpserver.utils.Constants;
import esa.httpserver.utils.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

abstract class BaseRequestHandle
implements RequestHandle {
    final ServerRuntime runtime;
    final ChannelHandlerContext ctx;
    final HttpMethod method;
    final QueryStringDecoder uriDecoded;
    Map<String, esa.commons.http.Cookie> cookies;
    SocketAddress remoteAddress;
    private Consumer<ByteBuf> onData;
    private Consumer<HttpHeaders> onTrailer;
    private Function<Promise<Void>, Future<Void>> onEnd;
    private Consumer<Throwable> onError;
    private AggregationHandle aggregation;
    private MultipartHandle multipart;
    volatile boolean isEnded;

    BaseRequestHandle(ServerRuntime runtime, ChannelHandlerContext ctx, HttpMethod method, String uri) {
        this.runtime = runtime;
        this.ctx = ctx;
        this.method = method;
        this.uriDecoded = new QueryStringDecoder(uri);
    }

    @Override
    public String scheme() {
        return (String)this.ctx.channel().attr(Constants.SCHEME).get();
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String uri() {
        return this.uriDecoded.uri();
    }

    @Override
    public String path() {
        return this.uriDecoded.path();
    }

    @Override
    public String query() {
        return this.uriDecoded.rawQuery();
    }

    @Override
    public Map<String, List<String>> paramMap() {
        return this.uriDecoded.parameters();
    }

    @Override
    public Map<String, esa.commons.http.Cookie> cookies() {
        if (this.cookies == null) {
            String value = this.headers().get((CharSequence)HttpHeaderNames.COOKIE);
            if (StringUtils.isEmpty((String)value)) {
                this.cookies = Collections.emptyMap();
            } else {
                Set decoded = ServerCookieDecoder.STRICT.decode(value);
                HashMap<String, esa.commons.http.Cookie> map = new HashMap<String, esa.commons.http.Cookie>(decoded.size());
                for (Cookie c : decoded) {
                    map.put(c.name(), (esa.commons.http.Cookie)new CookieImpl(c));
                }
                this.cookies = map;
            }
        }
        return this.cookies;
    }

    @Override
    public SocketAddress remoteAddress() {
        if (this.remoteAddress == null) {
            SocketAddress msg = (SocketAddress)this.ctx.channel().attr(Utils.SOURCE_ADDRESS).get();
            this.remoteAddress = msg == null ? this.tcpSourceAddress() : msg;
        }
        return this.remoteAddress;
    }

    @Override
    public SocketAddress tcpSourceAddress() {
        return this.ctx.channel().remoteAddress();
    }

    @Override
    public SocketAddress localAddress() {
        return this.ctx.channel().localAddress();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.ctx.alloc();
    }

    @Override
    public RequestHandle onData(Consumer<ByteBuf> h) {
        this.onData = h;
        return this;
    }

    @Override
    public RequestHandle onTrailer(Consumer<HttpHeaders> h) {
        this.onTrailer = h;
        return this;
    }

    @Override
    public RequestHandle onEnd(Function<Promise<Void>, Future<Void>> h) {
        this.onEnd = h;
        return this;
    }

    @Override
    public RequestHandle onError(Consumer<Throwable> h) {
        this.onError = h;
        return this;
    }

    @Override
    public MultiPart multipart() {
        return this.multipart == null ? MultipartHandle.EMPTY : this.multipart;
    }

    @Override
    public Aggregation aggregated() {
        return this.aggregation == null ? AggregationHandle.EMPTY : this.aggregation;
    }

    @Override
    public RequestHandle aggregate(boolean aggregate) {
        this.checkEnded();
        if (aggregate) {
            if (this.aggregation == null) {
                this.aggregation = new AggregationHandle(this.ctx);
            }
        } else if (this.aggregation != null) {
            this.aggregation.release();
            this.aggregation = null;
        }
        return this;
    }

    @Override
    public RequestHandle multipart(boolean expect) {
        this.checkEnded();
        if (expect) {
            HttpRequest request;
            if (this.multipart == null && HttpPostRequestDecoder.isMultipart((HttpRequest)(request = this.toHttpRequest()))) {
                this.multipart = new MultipartHandle(new HttpPostRequestDecoder(this.runtime.multipartDataFactory(), request));
            }
        } else if (this.multipart != null) {
            this.multipart.release();
            this.multipart = null;
        }
        return this;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public abstract BaseResponse<? extends BaseRequestHandle> response();

    void handleContent(ByteBuf buf) {
        if (this.multipart != null) {
            this.multipart.onData(buf.duplicate());
        }
        if (this.aggregation != null) {
            this.aggregation.appendPartialContent(this.onData == null ? buf.retain() : buf.retainedDuplicate());
        }
        if (this.onData != null) {
            this.onData.accept(buf);
        }
    }

    void handleTrailer(HttpHeaders trailers) {
        if (this.aggregation != null) {
            this.aggregation.setTrailers(trailers);
        }
        if (this.onTrailer != null) {
            this.onTrailer.accept(trailers);
        }
    }

    void handleEnd() {
        if (this.multipart != null) {
            this.multipart.end();
        }
        if (this.onEnd != null) {
            Future<Void> f = this.onEnd.apply((Promise<Void>)this.ctx.newPromise());
            if (f.isDone()) {
                this.windUp(f);
            } else {
                f.addListener(this::windUp);
            }
        } else {
            this.windUp((Future<? super Void>)this.ctx.newSucceededFuture());
        }
    }

    private void windUp(Future<? super Void> f) {
        try {
            if (f.isSuccess()) {
                if (((BaseResponse)this.response()).isCommitted()) {
                    if (!((BaseResponse)this.response()).isEnded()) {
                        Loggers.logger().warn("Response of {} hasn't been ended after processing.", (Object)this.toString());
                    }
                } else if (!((BaseResponse)this.response()).tryEnd(HttpResponseStatus.valueOf((int)((BaseResponse)this.response()).status()), () -> Unpooled.EMPTY_BUFFER, false) && Loggers.logger().isDebugEnabled()) {
                    Loggers.logger().debug("Failed to end response of {} after processing", (Object)this.toString());
                }
            } else if (!((BaseResponse)this.response()).tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(f.cause()), false)) {
                Loggers.logger().warn("Error occurred while processing {}, but failed to end response", (Object)this.toString());
            }
        }
        finally {
            this.release();
        }
    }

    void handleError(Throwable err) {
        try {
            if (this.onError != null) {
                this.onError.accept(err);
            }
        }
        finally {
            this.release();
        }
    }

    private void release() {
        if (this.multipart != null) {
            this.multipart.release();
            this.multipart = null;
        }
        if (this.aggregation != null) {
            this.aggregation.release();
            this.aggregation = null;
        }
    }

    private void checkEnded() {
        if (this.isEnded()) {
            throw new IllegalStateException("Already ended");
        }
    }

    protected abstract HttpRequest toHttpRequest();

    public String toString() {
        return StringUtils.concat((String[])new String[]{"Request", ((BaseResponse)this.response()).isCommitted() ? "![" : "-[", this.version().name(), " ", this.rawMethod(), " ", this.path(), "]"});
    }
}

