/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import esa.commons.StringUtils;
import esa.commons.http.Cookie;
import esa.commons.http.MimeMappings;
import esa.commons.netty.http.CookieImpl;
import esa.httpserver.core.Response;
import esa.httpserver.impl.BaseRequestHandle;
import esa.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

abstract class BaseResponse<REQ extends BaseRequestHandle>
implements Response {
    final REQ request;
    final ChannelPromise onEndPromise;
    final ChannelPromise endPromise;
    int status = 200;
    private volatile Thread committed;
    private volatile boolean ended;
    private static final AtomicReferenceFieldUpdater<BaseResponse, Thread> COMMITTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseResponse.class, Thread.class, "committed");

    BaseResponse(REQ req) {
        this.request = req;
        this.onEndPromise = ((BaseRequestHandle)req).ctx.newPromise();
        this.endPromise = ((BaseRequestHandle)req).ctx.newPromise();
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public Response setStatus(int code) {
        if (this.isCommitted()) {
            return this;
        }
        this.status = code;
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        return ((BaseRequestHandle)this.request).runtime.isRunning();
    }

    @Override
    public Response addCookie(Cookie cookie) {
        this.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookie.encode(true));
        return this;
    }

    @Override
    public Response addCookie(String name, String value) {
        return this.addCookie((Cookie)new CookieImpl(name, value));
    }

    @Override
    public Future<Void> write(byte[] data) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        return this.write0(data, 0, data.length);
    }

    @Override
    public Future<Void> write(byte[] data, int offset) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        int len = data.length - offset;
        Utils.checkIndex(data, offset, len);
        return this.write0(data, offset, len);
    }

    @Override
    public Future<Void> write(byte[] data, int offset, int length) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        Utils.checkIndex(data, offset, length);
        return this.write0(data, offset, length);
    }

    private Future<Void> write0(byte[] data, int offset, int length) {
        boolean casWon = this.ensureCommittedExclusively();
        if (!casWon && this.isEnded()) {
            throw new IllegalStateException("Already ended");
        }
        return this.doWrite(data, offset, length, casWon);
    }

    @Override
    public Future<Void> write(ByteBuf data) {
        boolean casWon;
        if (data == null) {
            data = Unpooled.EMPTY_BUFFER;
        }
        if (!(casWon = this.ensureCommittedExclusively()) && this.isEnded()) {
            throw new IllegalStateException("Already ended");
        }
        return this.doWrite(data, casWon);
    }

    @Override
    public Future<Void> end(byte[] data) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        return this.end0(data, 0, data.length);
    }

    @Override
    public Future<Void> end(byte[] data, int offset) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        int len = data.length - offset;
        Utils.checkIndex(data, offset, len);
        return this.end0(data, offset, len);
    }

    @Override
    public Future<Void> end(byte[] data, int offset, int length) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        Utils.checkIndex(data, offset, length);
        return this.end0(data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> end0(byte[] data, int offset, int length) {
        boolean casWon = this.ensureEndedExclusively();
        try {
            this.doEnd(data, offset, length, casWon);
        }
        finally {
            if (!this.isKeepAlive()) {
                this.endPromise.addListener((GenericFutureListener)this.closure());
            }
            Utils.trySuccess(this.onEndPromise, null);
        }
        return this.endPromise;
    }

    @Override
    public Future<Void> end(ByteBuf data) {
        if (data == null) {
            data = Unpooled.EMPTY_BUFFER;
        }
        boolean casWon = this.ensureEndedExclusively();
        try {
            this.doEnd(data, casWon, false);
        }
        finally {
            if (!this.isKeepAlive()) {
                this.endPromise.addListener((GenericFutureListener)this.closure());
            }
            Utils.trySuccess(this.onEndPromise, null);
        }
        return this.endPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> sendFile(File file, long offset, long length) {
        Checks.checkNotNull((Object)file, (String)"file");
        Checks.checkArg((offset >= 0L ? 1 : 0) != 0, (String)"negative offset");
        Checks.checkArg((length >= 0L ? 1 : 0) != 0, (String)"negative length");
        if (file.isHidden() || !file.exists() || file.isDirectory() || !file.isFile()) {
            ExceptionUtils.throwException((Throwable)new FileNotFoundException(file.getName()));
        }
        if (!this.ensureEndedExclusively()) {
            throw new IllegalStateException("Already committed");
        }
        if (!this.headers().contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
            String contentType = MimeMappings.getMimeTypeOrDefault((String)file.getPath());
            this.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        long len = Math.min(length, file.length() - offset);
        long position = Math.min(offset, file.length());
        try {
            this.doSendFile(file, position, len);
        }
        finally {
            if (!this.isKeepAlive()) {
                this.endPromise.addListener((GenericFutureListener)this.closure());
            }
            Utils.trySuccess(this.onEndPromise, null);
        }
        return this.endPromise;
    }

    @Override
    public boolean isWritable() {
        return ((BaseRequestHandle)this.request).ctx.channel().isWritable();
    }

    @Override
    public boolean isCommitted() {
        return this.committed != null;
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public Future<Void> onEndFuture() {
        return this.onEndPromise;
    }

    @Override
    public Future<Void> endFuture() {
        return this.endPromise;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.ctx().alloc();
    }

    public String toString() {
        return StringUtils.concat((String[])new String[]{"Response", this.isCommitted() ? "![" : "-[", this.request.rawMethod(), " ", ((BaseRequestHandle)this.request).path(), " ", Integer.toString(this.status), "]"});
    }

    boolean ensureEndedExclusively() {
        boolean committed = this.ensureCommittedExclusively();
        if (this.ended) {
            throw new IllegalStateException("Already ended");
        }
        this.ended = true;
        return committed;
    }

    boolean ensureCommittedExclusively() {
        Thread current = Thread.currentThread();
        if (COMMITTED_UPDATER.compareAndSet(this, null, current)) {
            return true;
        }
        if (current == this.committed) {
            return false;
        }
        throw new IllegalStateException("Should be committed by same thread. expected '" + this.committed.getName() + "' but '" + current.getName() + "'");
    }

    ChannelHandlerContext ctx() {
        return ((BaseRequestHandle)this.request).ctx;
    }

    boolean tryEndWithCrash(Throwable t) {
        if (this.tryEnd()) {
            Utils.tryFailure(this.onEndPromise, t);
            Utils.tryFailure(this.endPromise, t);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryEnd(HttpResponseStatus status, Supplier<ByteBuf> data, boolean forceClose) {
        if (this.tryEnd()) {
            try {
                this.status = status.code();
                this.doEnd(data.get(), true, forceClose);
                boolean bl = true;
                return bl;
            }
            finally {
                if (forceClose || !this.isKeepAlive()) {
                    this.endPromise.addListener((GenericFutureListener)this.closure());
                }
                Utils.trySuccess(this.onEndPromise, null);
            }
        }
        return false;
    }

    private boolean tryEnd() {
        Thread current;
        if (this.committed == null && COMMITTED_UPDATER.compareAndSet(this, null, current = Thread.currentThread())) {
            this.ended = true;
            return true;
        }
        return false;
    }

    abstract Future<Void> doWrite(ByteBuf var1, boolean var2);

    abstract Future<Void> doWrite(byte[] var1, int var2, int var3, boolean var4);

    abstract void doEnd(ByteBuf var1, boolean var2, boolean var3);

    abstract void doEnd(byte[] var1, int var2, int var3, boolean var4);

    abstract void doSendFile(File var1, long var2, long var4);

    abstract ChannelFutureListener closure();
}

