/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.Checks;
import esa.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import java.util.List;
import java.util.function.BiConsumer;

final class H2cDetector
extends ByteToMessageDecoder {
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer((ByteBuf)Http2CodecUtil.connectionPrefaceBuf());
    private final BiConsumer<ChannelHandlerContext, Boolean> callback;

    H2cDetector(BiConsumer<ChannelHandlerContext, Boolean> callback) {
        Checks.checkNotNull(callback, (String)"callback");
        this.callback = callback;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int prefaceLength = CONNECTION_PREFACE.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLength);
        if (!ByteBufUtil.equals((ByteBuf)CONNECTION_PREFACE, (int)CONNECTION_PREFACE.readerIndex(), (ByteBuf)in, (int)in.readerIndex(), (int)bytesRead)) {
            this.callback.accept(ctx, false);
            ctx.pipeline().remove((ChannelHandler)this);
        } else if (bytesRead == prefaceLength) {
            this.callback.accept(ctx, true);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Utils.handleException(ctx, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!Utils.handleIdle(ctx, evt)) {
            super.userEventTriggered(ctx, evt);
        }
    }
}

