/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.http.HttpHeaders;
import esa.commons.http.HttpMethod;
import esa.httpserver.core.RequestHandle;
import esa.httpserver.impl.BaseRequestHandle;
import esa.httpserver.impl.Http1ResponseImpl;
import esa.httpserver.impl.ServerRuntime;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;

final class Http1RequestHandleImpl
extends BaseRequestHandle
implements RequestHandle {
    final HttpRequest req;
    private final Http1ResponseImpl response;

    Http1RequestHandleImpl(ServerRuntime runtime, ChannelHandlerContext ctx, HttpRequest req, boolean isKeepAlive) {
        super(runtime, ctx, HttpMethod.fastValueOf((String)req.method().name()), req.uri());
        this.req = req;
        this.response = new Http1ResponseImpl(this, isKeepAlive);
    }

    @Override
    public esa.commons.http.HttpVersion version() {
        HttpVersion version = this.req.protocolVersion();
        if (version == HttpVersion.HTTP_1_0) {
            return esa.commons.http.HttpVersion.HTTP_1_0;
        }
        return esa.commons.http.HttpVersion.HTTP_1_1;
    }

    @Override
    public HttpHeaders headers() {
        return (HttpHeaders)this.req.headers();
    }

    @Override
    public Http1ResponseImpl response() {
        return this.response;
    }

    @Override
    protected HttpRequest toHttpRequest() {
        return this.req;
    }
}

