/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.Checks;
import esa.commons.http.HttpHeaders;
import esa.commons.http.HttpVersion;
import esa.commons.netty.http.Http1HeadersImpl;
import esa.httpserver.core.RequestHandle;
import esa.httpserver.impl.BaseRequestHandle;
import esa.httpserver.impl.Http2HeadersImpl;
import esa.httpserver.impl.Http2ResponseImpl;
import esa.httpserver.impl.ServerRuntime;
import esa.httpserver.impl.Utils;
import esa.httpserver.utils.Constants;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;

final class Http2RequestHandleImpl
extends BaseRequestHandle
implements RequestHandle {
    private final Http2HeadersImpl headers;
    private final Http2ResponseImpl response;
    private final String schema;
    final Http2Stream stream;
    long bytes;

    static Http2RequestHandleImpl from(ServerRuntime runtime, ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, Http2Headers h2Headers, Http2Stream stream, int streamDependency, short weight, boolean exclusive) {
        String path = ((CharSequence)Checks.checkNotNull((Object)h2Headers.path(), (String)"path")).toString();
        esa.commons.http.HttpMethod method = esa.commons.http.HttpMethod.fastValueOf((String)((CharSequence)Checks.checkNotNull((Object)h2Headers.method(), (String)"method")).toString());
        CharSequence c = h2Headers.scheme();
        String schema = c == null ? (String)ctx.channel().attr(Constants.SCHEME).get() : c.toString();
        Utils.standardHttp2Headers(h2Headers);
        return new Http2RequestHandleImpl(runtime, ctx, encoder, path, method, schema, h2Headers, stream, streamDependency, weight, exclusive);
    }

    private Http2RequestHandleImpl(ServerRuntime runtime, ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, String uri, esa.commons.http.HttpMethod method, String schema, Http2Headers headers, Http2Stream stream, int streamDependency, short weight, boolean exclusive) {
        super(runtime, ctx, method, uri);
        this.schema = schema;
        this.headers = new Http2HeadersImpl(headers);
        this.bytes = headers.getLong((Object)HttpHeaderNames.CONTENT_LENGTH, -1L);
        this.stream = stream;
        this.response = new Http2ResponseImpl(this, encoder, streamDependency, weight, exclusive);
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public String scheme() {
        return this.schema;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public Http2ResponseImpl response() {
        return this.response;
    }

    @Override
    protected HttpRequest toHttpRequest() {
        return new DefaultHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.rawMethod()), this.uri(), (io.netty.handler.codec.http.HttpHeaders)new Http1HeadersImpl().add(this.headers()));
    }
}

