/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import esa.commons.NetworkUtils;
import esa.commons.StringUtils;
import esa.httpserver.HttpServer;
import esa.httpserver.ServerOptions;
import esa.httpserver.core.RequestHandle;
import esa.httpserver.impl.HttpServerChannelInitializr;
import esa.httpserver.impl.ServerRuntime;
import esa.httpserver.impl.SslHelper;
import esa.httpserver.metrics.Metrics;
import esa.httpserver.transport.Transport;
import esa.httpserver.transport.Transports;
import esa.httpserver.utils.LoggedThreadFactory;
import esa.httpserver.utils.Loggers;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class HttpServerImpl
implements HttpServer {
    private static final AtomicInteger SERVER_NAME_IDENTIFIER = new AtomicInteger(0);
    private final ServerRuntime runtime;
    private Consumer<RequestHandle> handler;
    private Consumer<ChannelHandlerContext> onConnected;
    private Consumer<Channel> onDisconnected;
    private final CloseFuture closeFuture = new CloseFuture();
    private final CopyOnWriteArrayList<Runnable> closures = new CopyOnWriteArrayList();

    public HttpServerImpl(ServerOptions serverOptions) {
        this(null, serverOptions);
    }

    public HttpServerImpl(String name, ServerOptions serverOptions) {
        name = StringUtils.isEmpty((String)name) ? HttpServerImpl.nextServerName() : name + "#" + SERVER_NAME_IDENTIFIER.incrementAndGet();
        this.runtime = new ServerRuntime(StringUtils.nonEmptyOrElse((String)name, (String)HttpServerImpl.nextServerName()), serverOptions, this.closeFuture);
    }

    @Override
    public synchronized HttpServerImpl handle(Consumer<RequestHandle> h) {
        this.checkStarted();
        this.handler = h;
        return this;
    }

    @Override
    public synchronized HttpServerImpl onConnected(Consumer<ChannelHandlerContext> h) {
        this.checkStarted();
        this.onConnected = h;
        return this;
    }

    @Override
    public synchronized HttpServerImpl onDisconnected(Consumer<Channel> h) {
        this.checkStarted();
        this.onDisconnected = h;
        return this;
    }

    @Override
    public HttpServerImpl onClose(Runnable closure) {
        Checks.checkNotNull((Object)closure, (String)"closure");
        this.closures.add(closure);
        return this;
    }

    @Override
    public HttpServerImpl listen(int port) {
        return this.listen(new InetSocketAddress(port));
    }

    @Override
    public HttpServerImpl listen(String host, int port) {
        return this.listen(SocketUtils.socketAddress((String)host, (int)port));
    }

    @Override
    public HttpServerImpl listen(SocketAddress address) {
        return this.listen0(address);
    }

    @Override
    public String name() {
        return this.runtime.name();
    }

    @Override
    public void await() throws InterruptedException {
        if (this.runtime.isRunning()) {
            this.closeFuture().await();
        }
    }

    @Override
    public void awaitUninterruptibly() {
        if (this.runtime.isRunning()) {
            this.closeFuture().awaitUninterruptibly();
        }
    }

    @Override
    public Future<Void> closeFuture() {
        return this.closeFuture;
    }

    private synchronized HttpServerImpl listen0(SocketAddress address) {
        this.checkStarted();
        Checks.checkNotNull((Object)address, (String)"address");
        Checks.checkNotNull(this.handler, (String)"Request handler required");
        ServerBootstrap bootstrap = new ServerBootstrap();
        Transport transport = Transports.transport(this.options().isPreferNativeTransport());
        bootstrap.channelFactory(transport.serverChannelFactory(address));
        transport.applyOptions(bootstrap, this.options(), address);
        SslHelper sslHelper = new SslHelper(this.options().getSsl(), this.options().getH2() != null && this.options().getH2().isEnabled());
        this.runtime.metrics().initSsl(sslHelper.getSslContext());
        bootstrap.childHandler((ChannelHandler)new HttpServerChannelInitializr(this.runtime, sslHelper, this.handler, this.onConnected, this.onDisconnected));
        EventLoopGroup bossGroup = transport.loop(this.options().getBossThreads(), new LoggedThreadFactory(this.runtime.name() + "-Boss", this.options().isDaemon()));
        EventLoopGroup ioGroup = transport.loop(this.options().getIoThreads(), new LoggedThreadFactory(this.runtime.name() + "-I/O", this.options().isDaemon()));
        bootstrap.group(bossGroup, ioGroup);
        try {
            bootstrap.bind(address).syncUninterruptibly();
        }
        catch (Exception e) {
            Loggers.logger().error("Failed to start http server({}) on {}", new Object[]{this.runtime.name(), NetworkUtils.parseAddress((SocketAddress)address), e});
            bossGroup.shutdownGracefully();
            ioGroup.shutdownGracefully();
            ExceptionUtils.throwException((Throwable)e);
        }
        Loggers.logger().info("Http server({}) is listening on {}", (Object)this.runtime.name(), (Object)NetworkUtils.parseAddress((SocketAddress)address));
        this.runtime.setStarted(address, bossGroup, ioGroup);
        return this;
    }

    @Override
    public EventLoopGroup bossGroup() {
        return this.runtime.bossGroup();
    }

    @Override
    public EventLoopGroup ioGroup() {
        return this.runtime.ioGroup();
    }

    @Override
    public SocketAddress address() {
        return this.runtime.address();
    }

    @Override
    public Metrics metrics() {
        return this.runtime.metrics();
    }

    @Override
    public synchronized void close() {
        if (!this.runtime.isRunning()) {
            return;
        }
        this.close0();
    }

    private void close0() {
        Loggers.logger().info("Closing http server({}) ...", (Object)this.name());
        long start = System.nanoTime();
        ServerRuntime.Running status = this.runtime.setClosed();
        assert (status != null);
        Throwable t = null;
        try {
            if (status.bossGroup != null) {
                status.bossGroup.shutdownGracefully();
            }
        }
        catch (Throwable ex) {
            t = ex;
        }
        if (!this.closures.isEmpty()) {
            for (Runnable closure : this.closures) {
                try {
                    closure.run();
                }
                catch (Throwable ex) {
                    Loggers.logger().warn("Error while running closure of http server({})", (Object)this.name());
                }
            }
        }
        if (status.ioGroup != null) {
            try {
                status.ioGroup.shutdownGracefully();
            }
            catch (Throwable ex) {
                t = ex;
            }
        }
        this.closeFuture.setClosed();
        if (t != null) {
            Loggers.logger().error("Error while closing http server({})", (Object)this.name(), (Object)t);
            ExceptionUtils.throwException((Throwable)t);
        }
        Loggers.logger().info("Http server({}) closed in {} mills", (Object)this.name(), (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    private void checkStarted() {
        if (this.runtime.isRunning()) {
            throw new IllegalStateException("Server already started yet.");
        }
    }

    private ServerOptions options() {
        return this.runtime.options();
    }

    private static String nextServerName() {
        return "esa.httpserver#" + SERVER_NAME_IDENTIFIER.incrementAndGet();
    }

    static final class CloseFuture
    extends DefaultPromise<Void> {
        CloseFuture() {
            super((EventExecutor)GlobalEventExecutor.INSTANCE);
        }

        public Promise<Void> setSuccess(Void result) {
            throw new IllegalStateException();
        }

        public ChannelPromise setFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        public boolean trySuccess(Void result) {
            throw new IllegalStateException();
        }

        public boolean tryFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        private boolean setClosed() {
            return super.trySuccess(null);
        }
    }
}

