/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.StringUtils;
import esa.httpserver.impl.BaseResponse;
import esa.httpserver.utils.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;

final class Utils {
    static final byte[] EMPTY_BYTES = new byte[0];
    static final AttributeKey<SocketAddress> SOURCE_ADDRESS = AttributeKey.valueOf((String)"$source.address");

    static boolean handleIdle(ChannelHandlerContext ctx, Object event) {
        IdleStateEvent evt;
        if (event instanceof IdleStateEvent && (evt = (IdleStateEvent)event).state() == IdleState.ALL_IDLE) {
            if (Loggers.logger().isDebugEnabled()) {
                Loggers.logger().debug("Close timeout connection: {}", (Object)ctx.channel());
            }
            ctx.channel().close();
            return true;
        }
        return false;
    }

    static void handleException(ChannelHandlerContext ctx, Throwable cause) {
        if (cause instanceof IOException) {
            if (Loggers.logger().isDebugEnabled()) {
                Loggers.logger().debug("Exception occurred in connection: {}, maybe client has closed connection.", (Object)ctx.channel(), (Object)cause);
            }
        } else if (ctx.channel().isActive() && ctx.channel().isWritable()) {
            Loggers.logger().warn("Error occurred in connection: {}", (Object)ctx.channel(), (Object)cause);
        }
        ctx.channel().close();
    }

    static void standardHttp2Headers(Http2Headers headers) {
        for (Http2Headers.PseudoHeaderName p : Http2Headers.PseudoHeaderName.values()) {
            headers.remove((Object)p.value());
        }
        List cookies = headers.getAllAndRemove((Object)HttpHeaderNames.COOKIE);
        if (cookies != null && !cookies.isEmpty()) {
            headers.set((Object)HttpHeaderNames.COOKIE, (Object)String.join((CharSequence)"; ", cookies));
        }
    }

    static void tryRelease(ReferenceCounted target) {
        int refCnt = target.refCnt();
        if (refCnt > 0) {
            target.release();
        }
    }

    static <V> void trySuccess(Promise<? super V> p, V result) {
        if (!p.trySuccess(result)) {
            Throwable err = p.cause();
            if (err == null) {
                Loggers.logger().warn("Failed to mark a promise as success because it has succeeded already: {}", p);
            } else {
                Loggers.logger().warn("Failed to mark a promise as success because it has failed already: {}, unnotified cause:", p, (Object)err);
            }
        }
    }

    static void tryFailure(Promise<?> p, Throwable cause) {
        if (!p.tryFailure(cause)) {
            Throwable err = p.cause();
            if (err == null) {
                Loggers.logger().warn("Failed to mark a promise as failure because it has succeeded already: {}", p, (Object)cause);
            } else if (Loggers.logger().isWarnEnabled()) {
                Loggers.logger().warn("Failed to mark a promise as failure because it has failed already: {}, unnotified cause: {}", new Object[]{p, ThrowableUtil.stackTraceToString((Throwable)err), cause});
            }
        }
    }

    static ByteBuf toErrorMsg(BaseResponse r, Throwable t) {
        r.headers().clear();
        r.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
        return Utils.toErrorMsg(t);
    }

    static ByteBuf toErrorMsg(Throwable t) {
        ByteBuf err = StringUtils.isEmpty((String)t.getMessage()) ? Unpooled.EMPTY_BUFFER : Unpooled.copiedBuffer((byte[])t.getMessage().getBytes(StandardCharsets.UTF_8));
        return err;
    }

    static void checkIndex(byte[] bytes, int off, int len) {
        if (MathUtil.isOutOfBounds((int)off, (int)len, (int)bytes.length)) {
            throw new IndexOutOfBoundsException();
        }
    }

    static ByteBuf toByteBuf(ByteBufAllocator alloc, byte[] arr, int off, int length) {
        if (arr.length == 0 || length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf buf = alloc.buffer(length);
        return buf.writeBytes(arr, off, length);
    }

    static void safeRunInChannel(ChannelHandlerContext ctx, Runnable r, ChannelPromise promise, Object data) {
        try {
            ctx.channel().eventLoop().execute(r);
        }
        catch (Throwable cause) {
            if (promise != null) {
                Utils.tryFailure(promise, cause);
            }
            ReferenceCountUtil.release((Object)data);
            Loggers.logger().error("Failed to submit task to event loop.", cause);
        }
    }

    private Utils() {
    }
}

