/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.metrics.impl;

import esa.commons.Checks;
import esa.httpserver.metrics.OpenSslSessionMetrics;
import io.netty.handler.ssl.OpenSslSessionStats;

final class OpenSslSessionMetricsImpl
implements OpenSslSessionMetrics {
    static final OpenSslSessionMetrics DISABLED = new Disabled();
    private final OpenSslSessionStats stats;

    OpenSslSessionMetricsImpl(OpenSslSessionStats stats) {
        Checks.checkNotNull((Object)stats, (String)"stats");
        this.stats = stats;
    }

    @Override
    public long number() {
        return this.stats.number();
    }

    @Override
    public long accept() {
        return this.stats.accept();
    }

    @Override
    public long acceptGood() {
        return this.stats.acceptGood();
    }

    @Override
    public long acceptRenegotiate() {
        return this.stats.acceptRenegotiate();
    }

    @Override
    public long hits() {
        return this.stats.hits();
    }

    @Override
    public long cbHits() {
        return this.stats.cbHits();
    }

    @Override
    public long misses() {
        return this.stats.misses();
    }

    @Override
    public long timeouts() {
        return this.stats.timeouts();
    }

    @Override
    public long cacheFull() {
        return this.stats.cacheFull();
    }

    @Override
    public long ticketKeyFail() {
        return this.stats.ticketKeyFail();
    }

    @Override
    public long ticketKeyNew() {
        return this.stats.ticketKeyNew();
    }

    @Override
    public long ticketKeyRenew() {
        return this.stats.ticketKeyRenew();
    }

    @Override
    public long ticketKeyResume() {
        return this.stats.ticketKeyResume();
    }

    private static class Disabled
    implements OpenSslSessionMetrics {
        private Disabled() {
        }

        @Override
        public long number() {
            return 0L;
        }

        @Override
        public long accept() {
            return 0L;
        }

        @Override
        public long acceptGood() {
            return 0L;
        }

        @Override
        public long acceptRenegotiate() {
            return 0L;
        }

        @Override
        public long hits() {
            return 0L;
        }

        @Override
        public long cbHits() {
            return 0L;
        }

        @Override
        public long misses() {
            return 0L;
        }

        @Override
        public long timeouts() {
            return 0L;
        }

        @Override
        public long cacheFull() {
            return 0L;
        }

        @Override
        public long ticketKeyFail() {
            return 0L;
        }

        @Override
        public long ticketKeyNew() {
            return 0L;
        }

        @Override
        public long ticketKeyRenew() {
            return 0L;
        }

        @Override
        public long ticketKeyResume() {
            return 0L;
        }
    }
}

