/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.transport;

import esa.httpserver.NetOptions;
import esa.httpserver.transport.NioTransport;
import esa.httpserver.transport.Transport;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public final class EpollTransport
extends NioTransport
implements Transport {
    @Override
    public ChannelFactory<ServerChannel> serverChannelFactory(SocketAddress local) {
        if (local instanceof DomainSocketAddress) {
            return EpollServerDomainSocketChannel::new;
        }
        return EpollServerSocketChannel::new;
    }

    @Override
    public EventLoopGroup loop(int nThreads, ThreadFactory threadFactory) {
        return new EpollEventLoopGroup(nThreads, threadFactory);
    }

    @Override
    public void applyOptions(ServerBootstrap bootstrap, NetOptions options, SocketAddress local) {
        boolean isDomainSocket = local instanceof DomainSocketAddress;
        if (!isDomainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)options.isReusePort());
        }
        if (options.isTcpFastOpen()) {
            bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, (Object)true);
        }
        bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, (Object)options.isTcpQuickAck());
        bootstrap.childOption(EpollChannelOption.TCP_CORK, (Object)options.isTcpCork());
        super.applyOptions(bootstrap, options, local);
    }
}

