/*
 * Copyright 2020 OPPO ESA Stack Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package esa.httpserver.core;

import esa.commons.http.HttpHeaders;
import io.netty.buffer.ByteBuf;

/**
 * An interface defines the body and trailing headers part of a http request.
 */
public interface Aggregation {

    /**
     * Gets the request body.
     *
     * @return body or {@code empty} if there's no data received.
     */
    ByteBuf body();

    /**
     * Gets the request trailing headers.
     *
     * @return headers or {@code empty} if there's no trailer received.
     */
    HttpHeaders trailers();
}
