/*
 * Copyright 2020 OPPO ESA Stack Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package esa.httpserver.transport;

import io.netty.channel.epoll.Epoll;

public final class Transports {

    /**
     * Fetches an instance of {@link Transport}.
     *
     * @param preferNative is prefer to use native transports such as {@link EpollTransport}
     *
     * @return suitable instance of {@link Transport}.
     */
    public static Transport transport(boolean preferNative) {
        Transport transport = null;
        try {
            if (preferNative && Epoll.isAvailable()) {
                transport = new EpollTransport();
            }
        } catch (Throwable ignored) {
        }
        if (transport == null) {
            transport = NioTransport.INSTANCE;
        }
        return transport;
    }

    private Transports() {
    }

}
