/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.internal.StringUtil;
import java.util.Map;

final class AggregatedLastHttpContent
implements LastHttpContent {
    private final ByteBuf content;
    private final HttpHeaders trailers;

    AggregatedLastHttpContent(ByteBuf content, HttpHeaders trailers) {
        this.content = content;
        this.trailers = trailers;
    }

    public ByteBuf content() {
        return this.content;
    }

    public AggregatedLastHttpContent copy() {
        return this.replace(this.content.copy());
    }

    public AggregatedLastHttpContent duplicate() {
        return this.replace(this.content.duplicate());
    }

    public AggregatedLastHttpContent replace(ByteBuf content) {
        return new AggregatedLastHttpContent(content, this.trailers.copy());
    }

    public AggregatedLastHttpContent retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    public HttpHeaders trailingHeaders() {
        return this.trailers;
    }

    public DecoderResult decoderResult() {
        return DecoderResult.SUCCESS;
    }

    @Deprecated
    public DecoderResult getDecoderResult() {
        return this.decoderResult();
    }

    public void setDecoderResult(DecoderResult result) {
        throw new UnsupportedOperationException("read only");
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public AggregatedLastHttpContent retain() {
        this.content.retain();
        return this;
    }

    public AggregatedLastHttpContent retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    public AggregatedLastHttpContent touch() {
        this.content.touch();
        return this;
    }

    public AggregatedLastHttpContent touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(StringUtil.simpleClassName((Object)this) + "(data: " + this.content() + ", decoderResult: " + this.decoderResult() + ')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.trailingHeaders()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

