/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.stream.ChunkedInput;

final class Http2ChunkedInput
implements ChunkedInput<Content> {
    private final ChunkedInput<ByteBuf> input;
    private final int streamId;
    private final int streamDependency;
    private final short weight;
    private final boolean exclusive;
    private final Http2Headers trailers;

    Http2ChunkedInput(ChunkedInput<ByteBuf> input, Http2Headers trailers, int streamId, int streamDependency, short weight, boolean exclusive) {
        this.input = input;
        this.trailers = trailers;
        this.streamId = streamId;
        this.streamDependency = streamDependency;
        this.weight = weight;
        this.exclusive = exclusive;
    }

    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    public void close() throws Exception {
        this.input.close();
    }

    @Deprecated
    public Content readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public Content readChunk(ByteBufAllocator allocator) throws Exception {
        ByteBuf buf = (ByteBuf)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        if (this.input.isEndOfInput()) {
            return new LastContent(buf, this.trailers, this.streamId, this.streamDependency, this.weight, this.exclusive);
        }
        return new Content(buf, this.streamId);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }

    static final class LastContent
    extends Content {
        final Http2Headers trailers;
        final int streamDependency;
        final short weight;
        final boolean exclusive;

        LastContent(ByteBuf content, Http2Headers trailers, int streamId, int streamDependency, short weight, boolean exclusive) {
            super(content, streamId);
            this.trailers = trailers;
            this.streamDependency = streamDependency;
            this.weight = weight;
            this.exclusive = exclusive;
        }
    }

    static class Content
    extends DefaultHttpContent {
        final int streamId;

        Content(ByteBuf content, int streamId) {
            super(content);
            this.streamId = streamId;
        }
    }
}

