/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.http.HttpHeaders;
import esa.httpserver.core.RequestHandle;
import esa.httpserver.impl.Http2HeadersImpl;
import esa.httpserver.impl.Http2RequestHandleImpl;
import esa.httpserver.impl.Http2ResponseImpl;
import esa.httpserver.impl.ServerRuntime;
import esa.httpserver.impl.Utils;
import esa.httpserver.utils.Constants;
import esa.httpserver.utils.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import java.util.function.Consumer;

final class Http2Handler
extends Http2EventAdapter {
    private static final Http2Headers EXPECTATION_FAILED = (Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.EXPECTATION_FAILED.codeAsText()).setLong((Object)HttpHeaderNames.CONTENT_LENGTH, 0L);
    private static final Http2Headers TOO_LARGE = (Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.codeAsText()).setLong((Object)HttpHeaderNames.CONTENT_LENGTH, 0L);
    private static final Http2Headers CONTINUE = new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.CONTINUE.codeAsText());
    private final ServerRuntime runtime;
    private final Http2ConnectionEncoder encoder;
    private final Http2Connection.PropertyKey messageKey;
    private final Consumer<RequestHandle> handler;

    Http2Handler(ServerRuntime runtime, Http2ConnectionEncoder encoder, Consumer<RequestHandle> handler) {
        this.runtime = runtime;
        this.encoder = encoder;
        this.encoder.connection().addListener((Http2Connection.Listener)this);
        this.messageKey = encoder.connection().newKey();
        this.handler = handler;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endStream) {
        this.onHeadersRead(ctx, streamId, headers, 0, (short)16, false, padding, endStream);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        Http2RequestHandleImpl request = this.getCurrentRequest(stream);
        if (request == null) {
            CharSequence expectValue = (CharSequence)headers.get((Object)HttpHeaderNames.EXPECT);
            boolean requiredContentLengthValid = true;
            if (expectValue != null) {
                if (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase(expectValue)) {
                    if (this.isContentLengthInvalid(headers)) {
                        this.write413(ctx, stream, streamDependency, weight, exclusive);
                        return;
                    }
                    requiredContentLengthValid = false;
                    this.write100(ctx, stream, streamDependency, weight, exclusive);
                    headers.remove((Object)HttpHeaderNames.EXPECT);
                } else {
                    this.write417(ctx, stream, streamDependency, weight, exclusive);
                    return;
                }
            }
            if (requiredContentLengthValid && this.isContentLengthInvalid(headers)) {
                this.write413(ctx, stream, streamDependency, weight, exclusive);
                return;
            }
            headers.addLong((Object)Constants.TTFB, System.currentTimeMillis());
            try {
                request = Http2RequestHandleImpl.from(this.runtime, ctx, this.encoder, headers, stream, streamDependency, weight, exclusive);
                this.handler.accept(request);
                this.runtime.metrics().reportRequest(request);
            }
            catch (Throwable t) {
                if (request != null) {
                    this.error(null, request, t, r -> {
                        if (!r.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(r.response(), t), false)) {
                            Loggers.logger().warn("Error while accepting {}", r, (Object)t);
                        }
                    });
                    return;
                }
                Loggers.logger().error("Error while accepting http2 request", t);
                stream.close();
                return;
            }
        } else {
            Utils.standardHttp2Headers(headers);
            if (!this.handleTrailer(stream, request, (HttpHeaders)new Http2HeadersImpl(headers))) {
                return;
            }
        }
        if (endOfStream) {
            this.end(stream, request);
        } else {
            this.setHandler(stream, request);
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        Http2RequestHandleImpl request = this.getCurrentRequest(stream);
        if (request == null) {
            return data.readableBytes() + padding;
        }
        boolean dataHandled = true;
        int readableBytes = data.readableBytes();
        if (request.bytes > 0L) {
            if ((long)readableBytes > request.bytes) {
                dataHandled = this.handleData(stream, request, data.readSlice((int)request.bytes));
                request.bytes = 0L;
            } else {
                dataHandled = this.handleData(stream, request, data);
                request.bytes -= (long)readableBytes;
            }
        } else if (request.bytes < 0L) {
            if (this.runtime.options().getMaxContentLength() > 0L) {
                long limit = request.bytes + this.runtime.options().getMaxContentLength() + 1L;
                if ((long)readableBytes > limit) {
                    dataHandled = this.handleData(stream, request, data.readSlice((int)limit));
                    if (dataHandled) {
                        TooLongFrameException t = new TooLongFrameException("content length exceeded " + this.runtime.options().getMaxContentLength() + " bytes.");
                        Http2ResponseImpl response = request.response();
                        if (!response.tryEnd(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, () -> {
                            response.headers().clear();
                            response.headers().setLong((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0L);
                            return Unpooled.EMPTY_BUFFER;
                        }, false)) {
                            Loggers.logger().error("Request entity too large.", (Throwable)t);
                        }
                        this.error(stream, request, (Throwable)t, null);
                    }
                } else {
                    dataHandled = this.handleData(stream, request, data);
                    request.bytes -= (long)readableBytes;
                }
            } else {
                dataHandled = this.handleData(stream, request, data);
            }
        }
        if (endOfStream && dataHandled) {
            this.end(stream, request);
        }
        return readableBytes + padding;
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        Http2RequestHandleImpl req = this.removeRequest(stream);
        if (req != null) {
            Http2Exception t = Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.valueOf((long)errorCode), (String)"Stream reset.", (Object[])new Object[0]);
            if (!req.response().tryEndWithCrash((Throwable)t)) {
                Loggers.logger().warn("Stream({}) reset, but {} has been committed", (Object)stream.id(), (Object)req.response());
            }
            this.error(null, req, (Throwable)t, null);
        }
    }

    public void onStreamRemoved(Http2Stream stream) {
        Http2RequestHandleImpl req = this.removeRequest(stream);
        if (req != null) {
            Http2Exception t = Http2Exception.streamError((int)stream.id(), (Http2Error)Http2Error.STREAM_CLOSED, (String)"Stream removed.", (Object[])new Object[0]);
            if (!req.response().tryEndWithCrash((Throwable)t)) {
                Loggers.logger().warn("Stream({}) removed, but {} has been committed", (Object)stream.id(), (Object)req.response());
            }
            this.error(null, req, (Throwable)t, null);
        }
    }

    private boolean handleData(Http2Stream stream, Http2RequestHandleImpl req, ByteBuf data) {
        try {
            req.handleContent(data);
            return true;
        }
        catch (Throwable t) {
            this.error(stream, req, t, r -> {
                if (!req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(r.response(), t), false)) {
                    Loggers.logger().warn("Error while handing content: {}", (Object)t, (Object)req);
                }
            });
            return false;
        }
    }

    private boolean handleTrailer(Http2Stream stream, Http2RequestHandleImpl req, HttpHeaders trailer) {
        if (trailer != null && !trailer.isEmpty()) {
            try {
                req.handleTrailer(trailer);
            }
            catch (Throwable t) {
                this.error(stream, req, t, r -> {
                    if (!req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(r.response(), t), false)) {
                        Loggers.logger().warn("Error while handing trailers: {}", (Object)t, (Object)req);
                    }
                });
                return false;
            }
        }
        return true;
    }

    private void end(Http2Stream stream, Http2RequestHandleImpl req) {
        assert (req != null);
        req.isEnded = true;
        try {
            req.handleEnd();
            this.removeRequest(stream);
        }
        catch (Throwable t) {
            this.error(stream, req, t, r -> {
                if (req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(req.response(), t), false)) {
                    Loggers.logger().warn("Error while handing {}", (Object)t, (Object)req);
                }
            });
        }
    }

    private void error(Http2Stream stream, Http2RequestHandleImpl req, Throwable err, Consumer<Http2RequestHandleImpl> after) {
        if (stream != null) {
            this.removeRequest(stream);
        }
        if (!req.isEnded) {
            req.isEnded = true;
        }
        Throwable causeToCloseStream = null;
        try {
            req.handleError(err);
        }
        catch (Throwable t) {
            Loggers.logger().error("Error while handing {}, but another error was thrown by the onError() handler.", (Object)req, (Object)t);
            causeToCloseStream = t;
        }
        if (after != null) {
            after.accept(req);
        }
        if (causeToCloseStream != null && !req.response().isCommitted()) {
            req.stream.close();
        }
    }

    private Http2RequestHandleImpl getCurrentRequest(Http2Stream stream) {
        return (Http2RequestHandleImpl)stream.getProperty(this.messageKey);
    }

    private Http2RequestHandleImpl removeRequest(Http2Stream stream) {
        return (Http2RequestHandleImpl)stream.removeProperty(this.messageKey);
    }

    private void setHandler(Http2Stream stream, Http2RequestHandleImpl request) {
        Http2RequestHandleImpl p = (Http2RequestHandleImpl)stream.setProperty(this.messageKey, (Object)request);
        if (p != null) {
            p.handleError(new IllegalStateException("Unexpected error"));
        }
    }

    private boolean isShutdown() {
        return this.runtime.shutdownStatus().get();
    }

    private boolean isContentLengthInvalid(Http2Headers start) {
        long contentLength;
        return this.runtime.options().getMaxContentLength() > 0L && (contentLength = start.getLong((Object)HttpHeaderNames.CONTENT_LENGTH, -1L)) >= 0L && contentLength > this.runtime.options().getMaxContentLength();
    }

    private void write100(ChannelHandlerContext ctx, Http2Stream stream, int streamDependency, short weight, boolean exclusive) {
        this.encoder.writeHeaders(ctx, stream.id(), CONTINUE, streamDependency, weight, exclusive, 0, false, ctx.newPromise()).addListener(f -> {
            if (!f.isSuccess()) {
                Loggers.logger().warn("Failed to send a 100 Continue.", f.cause());
                stream.close();
            } else if (this.isShutdown() && ctx.channel().isActive()) {
                ctx.channel().close();
            }
        });
    }

    private void write413(ChannelHandlerContext ctx, Http2Stream stream, int streamDependency, short weight, boolean exclusive) {
        this.encoder.writeHeaders(ctx, stream.id(), TOO_LARGE, streamDependency, weight, exclusive, 0, true, ctx.newPromise()).addListener(f -> {
            if (!f.isSuccess()) {
                Loggers.logger().warn("Failed to send a 413 Request Entity Too Large.", f.cause());
                stream.close();
            } else if (this.isShutdown() && ctx.channel().isActive()) {
                ctx.channel().close();
            }
        });
    }

    private void write417(ChannelHandlerContext ctx, Http2Stream stream, int streamDependency, short weight, boolean exclusive) {
        this.encoder.writeHeaders(ctx, stream.id(), EXPECTATION_FAILED, streamDependency, weight, exclusive, 0, true, ctx.newPromise()).addListener(f -> {
            if (!f.isSuccess()) {
                Loggers.logger().warn("Failed to send a 417 Continue.", f.cause());
                stream.close();
            } else if (this.isShutdown() && ctx.channel().isActive()) {
                ctx.channel().close();
            }
        });
    }
}

