/*
 * Decompiled with CFR 0.152.
 */
package esa.httpserver.impl;

import esa.commons.function.Consumer3;
import esa.httpserver.impl.SslCompletionHandler;
import esa.httpserver.impl.SslHelper;
import esa.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import javax.net.ssl.SSLEngine;

final class SslDetector
extends ByteToMessageDecoder {
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private final SslHelper sslHelper;
    private final Consumer3<Boolean, Channel, Throwable> callback;

    SslDetector(SslHelper sslHelper, Consumer3<Boolean, Channel, Throwable> callback) {
        this.sslHelper = sslHelper;
        this.callback = callback;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        if (SslDetector.isSsl(in)) {
            SSLEngine engine = this.sslHelper.getSslContext().newEngine(ctx.alloc());
            if (this.sslHelper.options().getEnabledProtocols() != null && this.sslHelper.options().getEnabledProtocols().length > 0) {
                engine.setEnabledProtocols(this.sslHelper.options().getEnabledProtocols());
            }
            SslHandler sslHandler = new SslHandler(engine);
            if (this.sslHelper.options().getHandshakeTimeoutMillis() > 0L) {
                sslHandler.setHandshakeTimeoutMillis(this.sslHelper.options().getHandshakeTimeoutMillis());
            }
            ctx.pipeline().addAfter(ctx.name(), "SslCompletionHandler", (ChannelHandler)new SslCompletionHandler(this.callback));
            ctx.pipeline().replace((ChannelHandler)this, "SslHandler", (ChannelHandler)sslHandler);
        } else {
            this.callback.accept((Object)false, (Object)ctx.channel(), null);
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Utils.handleException(ctx, cause);
    }

    private static boolean isSsl(ByteBuf in) {
        return SslHandler.isEncrypted((ByteBuf)in);
    }
}

