/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver;

import esa.commons.Platforms;
import io.esastack.httpserver.H2Options;
import io.esastack.httpserver.HAProxyMode;
import io.esastack.httpserver.MultipartOptions;
import io.esastack.httpserver.NetOptions;
import io.esastack.httpserver.SslOptions;

public class ServerOptions
extends NetOptions {
    private static final long serialVersionUID = 822297421367421793L;
    private boolean daemon = true;
    private int bossThreads = 1;
    private int ioThreads = Platforms.cpuNum() << 1;
    private boolean compress = false;
    private boolean decompress = false;
    private int compressionLevel = 6;
    private boolean keepAliveEnable = true;
    private long maxContentLength = -1L;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private boolean metricsEnabled = false;
    private HAProxyMode haProxy = HAProxyMode.OFF;
    private SslOptions ssl;
    private H2Options h2 = new H2Options();
    private MultipartOptions multipart = new MultipartOptions();

    public ServerOptions() {
    }

    public ServerOptions(ServerOptions other) {
        super(other);
        this.daemon = other.daemon;
        this.bossThreads = other.bossThreads;
        this.ioThreads = other.ioThreads;
        this.compress = other.compress;
        this.decompress = other.decompress;
        this.compressionLevel = other.compressionLevel;
        this.keepAliveEnable = other.keepAliveEnable;
        this.maxContentLength = other.maxContentLength;
        this.maxInitialLineLength = other.maxInitialLineLength;
        this.maxHeaderSize = other.maxHeaderSize;
        this.maxChunkSize = other.maxChunkSize;
        this.metricsEnabled = other.metricsEnabled;
        this.haProxy = other.haProxy;
        this.ssl = other.ssl == null ? null : new SslOptions(other.ssl);
        this.h2 = other.h2 == null ? null : new H2Options(other.h2);
        this.multipart = other.multipart == null ? null : new MultipartOptions(other.multipart);
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public int getBossThreads() {
        return this.bossThreads;
    }

    public void setBossThreads(int bossThreads) {
        this.bossThreads = bossThreads;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isDecompress() {
        return this.decompress;
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public boolean isKeepAliveEnable() {
        return this.keepAliveEnable;
    }

    public void setKeepAliveEnable(boolean keepAliveEnable) {
        this.keepAliveEnable = keepAliveEnable;
    }

    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    public void setMaxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public int getMaxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    public void setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public HAProxyMode getHaProxy() {
        return this.haProxy;
    }

    public void setHaProxy(HAProxyMode haProxy) {
        this.haProxy = haProxy;
    }

    public SslOptions getSsl() {
        return this.ssl;
    }

    public void setSsl(SslOptions ssl) {
        this.ssl = ssl;
    }

    public H2Options getH2() {
        return this.h2;
    }

    public void setH2(H2Options h2) {
        this.h2 = h2;
    }

    public MultipartOptions getMultipart() {
        return this.multipart;
    }

    public void setMultipart(MultipartOptions multipart) {
        this.multipart = multipart;
    }
}

