/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.core;

import io.esastack.commons.net.http.Cookie;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.http.HttpMethod;
import io.esastack.commons.net.http.HttpVersion;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public interface BaseRequest {
    public HttpVersion version();

    public String scheme();

    public String uri();

    public String path();

    public String query();

    public HttpMethod method();

    default public String rawMethod() {
        return this.method().name();
    }

    default public String getParam(String parName) {
        List<String> params = this.getParams(parName);
        if (params != null && params.size() > 0) {
            return params.get(0);
        }
        return null;
    }

    default public List<String> getParams(String parName) {
        return this.paramMap().get(parName);
    }

    public Map<String, List<String>> paramMap();

    public HttpHeaders headers();

    public Map<String, Cookie> cookies();

    default public Cookie getCookie(String name) {
        return this.cookies().get(name);
    }

    public SocketAddress remoteAddress();

    public SocketAddress tcpSourceAddress();

    public SocketAddress localAddress();
}

