/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.core;

import esa.commons.Checks;
import esa.commons.annotation.Beta;
import io.esastack.commons.net.http.Cookie;
import io.esastack.commons.net.http.HttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Future;
import java.io.File;

public interface Response {
    public int status();

    public Response setStatus(int var1);

    public HttpHeaders headers();

    public HttpHeaders trailers();

    public Response addCookie(Cookie var1);

    public Response addCookie(String var1, String var2);

    public boolean isKeepAlive();

    default public Future<Void> write(byte[] data) {
        return this.write(data, 0);
    }

    default public Future<Void> write(byte[] data, int offset) {
        return this.write(data, offset, data == null ? 0 : data.length - offset);
    }

    public Future<Void> write(byte[] var1, int var2, int var3);

    public Future<Void> write(ByteBuf var1);

    default public Future<Void> end(byte[] data) {
        return this.end(data, 0);
    }

    default public Future<Void> end(byte[] data, int offset) {
        return this.end(data, offset, data == null ? 0 : data.length - offset);
    }

    public Future<Void> end(byte[] var1, int var2, int var3);

    default public Future<Void> end() {
        return this.end(Unpooled.EMPTY_BUFFER);
    }

    public Future<Void> end(ByteBuf var1);

    default public Future<Void> sendRedirect(String newUri) {
        Checks.checkNotEmptyArg((String)newUri, (String)"newUri");
        this.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        this.setStatus(HttpResponseStatus.FOUND.code());
        return this.end();
    }

    default public Future<Void> sendFile(File file) {
        return this.sendFile(file, 0L);
    }

    default public Future<Void> sendFile(File file, long offset) {
        return this.sendFile(file, offset, Long.MAX_VALUE);
    }

    public Future<Void> sendFile(File var1, long var2, long var4);

    public boolean isWritable();

    public boolean isCommitted();

    public boolean isEnded();

    public Future<Void> onEndFuture();

    public Future<Void> endFuture();

    @Beta
    public ByteBufAllocator alloc();
}

