/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.Checks;
import esa.commons.ExceptionUtils;
import esa.commons.StringUtils;
import esa.commons.http.MimeMappings;
import io.esastack.commons.net.http.Cookie;
import io.esastack.httpserver.core.Response;
import io.esastack.httpserver.impl.BaseRequestHandle;
import io.esastack.httpserver.impl.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

abstract class BaseResponse<REQ extends BaseRequestHandle>
implements Response {
    final REQ request;
    final ChannelPromise onEndPromise;
    final ChannelPromise endPromise;
    int status = 200;
    private volatile Object committed;
    private static final AtomicReferenceFieldUpdater<BaseResponse, Object> COMMITTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(BaseResponse.class, Object.class, "committed");
    private static final Object END = new Object();
    private static final Object IDLE = new Object();

    BaseResponse(REQ req) {
        this.request = req;
        this.onEndPromise = ((BaseRequestHandle)req).ctx.newPromise();
        this.endPromise = ((BaseRequestHandle)req).ctx.newPromise();
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public Response setStatus(int code) {
        this.status = code;
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        return ((BaseRequestHandle)this.request).runtime.isRunning();
    }

    @Override
    public Response addCookie(Cookie cookie) {
        this.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookie.encode(true));
        return this;
    }

    @Override
    public Response addCookie(String name, String value) {
        return this.addCookie(Cookie.cookie((String)name, (String)value));
    }

    @Override
    public Future<Void> write(byte[] data) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        return this.write0(data, 0, data.length);
    }

    @Override
    public Future<Void> write(byte[] data, int offset) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        int len = data.length - offset;
        Utils.checkIndex(data, offset, len);
        return this.write0(data, offset, len);
    }

    @Override
    public Future<Void> write(byte[] data, int offset, int length) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        Utils.checkIndex(data, offset, length);
        return this.write0(data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> write0(byte[] data, int offset, int length) {
        boolean writeHead = this.ensureCommitExclusively();
        try {
            Future<Void> future = this.doWrite(data, offset, length, writeHead);
            return future;
        }
        finally {
            COMMITTED_UPDATER.lazySet(this, IDLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> write(ByteBuf data) {
        if (data == null) {
            data = Unpooled.EMPTY_BUFFER;
        }
        boolean writeHead = this.ensureCommitExclusively();
        try {
            Future<Void> future = this.doWrite(data, writeHead);
            return future;
        }
        finally {
            COMMITTED_UPDATER.lazySet(this, IDLE);
        }
    }

    @Override
    public Future<Void> end(byte[] data) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        return this.end0(data, 0, data.length);
    }

    @Override
    public Future<Void> end(byte[] data, int offset) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        int len = data.length - offset;
        Utils.checkIndex(data, offset, len);
        return this.end0(data, offset, len);
    }

    @Override
    public Future<Void> end(byte[] data, int offset, int length) {
        if (data == null) {
            data = Utils.EMPTY_BYTES;
        }
        Utils.checkIndex(data, offset, length);
        return this.end0(data, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> end0(byte[] data, int offset, int length) {
        boolean writeHead = this.ensureEndExclusively(true);
        try {
            this.doEnd(data, offset, length, writeHead);
        }
        finally {
            if (!this.isKeepAlive()) {
                this.endPromise.addListener((GenericFutureListener)this.closure());
            }
            Utils.trySuccess(this.onEndPromise, null);
        }
        return this.endPromise;
    }

    @Override
    public Future<Void> end(ByteBuf data) {
        if (data == null) {
            data = Unpooled.EMPTY_BUFFER;
        }
        boolean writeHead = this.ensureEndExclusively(true);
        try {
            this.doEnd(data, writeHead, false);
        }
        finally {
            if (!this.isKeepAlive()) {
                this.endPromise.addListener((GenericFutureListener)this.closure());
            }
            Utils.trySuccess(this.onEndPromise, null);
        }
        return this.endPromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> sendFile(File file, long offset, long length) {
        Checks.checkNotNull((Object)file, (String)"file");
        Checks.checkArg((offset >= 0L ? 1 : 0) != 0, (String)"negative offset");
        Checks.checkArg((length >= 0L ? 1 : 0) != 0, (String)"negative length");
        if (file.isHidden() || !file.exists() || file.isDirectory() || !file.isFile()) {
            ExceptionUtils.throwException((Throwable)new FileNotFoundException(file.getName()));
        }
        this.ensureEndExclusively(false);
        if (!this.headers().contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
            String contentType = MimeMappings.getMimeTypeOrDefault((String)file.getPath());
            this.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        long len = Math.min(length, file.length() - offset);
        long position = Math.min(offset, file.length());
        try {
            this.doSendFile(file, position, len);
        }
        finally {
            if (!this.isKeepAlive()) {
                this.endPromise.addListener((GenericFutureListener)this.closure());
            }
            Utils.trySuccess(this.onEndPromise, null);
        }
        return this.endPromise;
    }

    @Override
    public boolean isWritable() {
        return ((BaseRequestHandle)this.request).ctx.channel().isWritable();
    }

    @Override
    public boolean isCommitted() {
        return COMMITTED_UPDATER.get(this) != null;
    }

    @Override
    public boolean isEnded() {
        return COMMITTED_UPDATER.get(this) == END;
    }

    @Override
    public Future<Void> onEndFuture() {
        return this.onEndPromise;
    }

    @Override
    public Future<Void> endFuture() {
        return this.endPromise;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.ctx().alloc();
    }

    public String toString() {
        Object committed = COMMITTED_UPDATER.get(this);
        String committedStatus = committed == null ? "-" : (committed == END ? "!" : "~");
        return StringUtils.concat((String[])new String[]{"Response", committedStatus, "[", this.request.rawMethod(), " ", ((BaseRequestHandle)this.request).path(), " ", Integer.toString(this.status), "]"});
    }

    boolean ensureCommitExclusively() {
        Object current = COMMITTED_UPDATER.get(this);
        if (current == null) {
            Thread t = Thread.currentThread();
            if (COMMITTED_UPDATER.compareAndSet(this, null, t)) {
                return true;
            }
            throw new IllegalStateException("Concurrent committing['INIT' -> '" + t.getName() + "']");
        }
        if (current == END) {
            throw new IllegalStateException("Already ended");
        }
        if (current == IDLE) {
            Thread t = Thread.currentThread();
            if (COMMITTED_UPDATER.compareAndSet(this, IDLE, t)) {
                return false;
            }
            throw new IllegalStateException("Concurrent committing['IDLE' -> '" + t.getName() + "']");
        }
        throw new IllegalStateException("Concurrent committing ['" + ((Thread)current).getName() + "' -> '" + Thread.currentThread().getName() + "']");
    }

    boolean ensureEndExclusively(boolean allowCommitted) {
        Object current = COMMITTED_UPDATER.get(this);
        if (current == null) {
            if (COMMITTED_UPDATER.compareAndSet(this, null, END)) {
                return true;
            }
            throw new IllegalStateException("Concurrent ending['INIT' -> 'END']");
        }
        if (current == IDLE) {
            if (allowCommitted && COMMITTED_UPDATER.compareAndSet(this, IDLE, END)) {
                return false;
            }
            throw new IllegalStateException("Concurrent ending['IDLE' -> 'END']");
        }
        if (current == END) {
            throw new IllegalStateException("Already ended");
        }
        throw new IllegalStateException("Concurrent ending['" + ((Thread)current).getName() + "' -> 'END']");
    }

    ChannelHandlerContext ctx() {
        return ((BaseRequestHandle)this.request).ctx;
    }

    boolean tryEndWithCrash(Throwable t) {
        if (this.tryEnd()) {
            Utils.tryFailure(this.onEndPromise, t);
            Utils.tryFailure(this.endPromise, t);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryEnd(HttpResponseStatus status, Supplier<ByteBuf> data, boolean forceClose) {
        if (this.tryEnd()) {
            try {
                this.status = status.code();
                this.doEnd(data.get(), true, forceClose);
                boolean bl = true;
                return bl;
            }
            finally {
                if (forceClose || !this.isKeepAlive()) {
                    this.endPromise.addListener((GenericFutureListener)this.closure());
                }
                Utils.trySuccess(this.onEndPromise, null);
            }
        }
        return false;
    }

    private boolean tryEnd() {
        Object current = COMMITTED_UPDATER.get(this);
        return current == null && COMMITTED_UPDATER.compareAndSet(this, null, END);
    }

    abstract Future<Void> doWrite(ByteBuf var1, boolean var2);

    abstract Future<Void> doWrite(byte[] var1, int var2, int var3, boolean var4);

    abstract void doEnd(ByteBuf var1, boolean var2, boolean var3);

    abstract void doEnd(byte[] var1, int var2, int var3, boolean var4);

    abstract void doSendFile(File var1, long var2, long var4);

    abstract ChannelFutureListener closure();
}

