/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import io.esastack.commons.net.http.EmptyHttpHeaders;
import io.esastack.commons.net.http.HttpHeaders;
import io.esastack.commons.net.netty.http.Http1HeadersAdaptor;
import io.esastack.httpserver.core.RequestHandle;
import io.esastack.httpserver.impl.Http1RequestHandleImpl;
import io.esastack.httpserver.impl.ServerRuntime;
import io.esastack.httpserver.impl.Utils;
import io.esastack.httpserver.utils.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

final class Http1Handler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE_CLOSE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse TOO_LARGE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, Unpooled.EMPTY_BUFFER);
    private final Consumer<RequestHandle> handler;
    private final ServerRuntime runtime;
    private Http1RequestHandleImpl current;
    private long chunkSize = -1L;

    Http1Handler(ServerRuntime runtime, Consumer<RequestHandle> handler) {
        this.runtime = runtime;
        this.handler = handler;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg.decoderResult().isFailure()) {
            this.decodeError(ctx, msg);
            return;
        }
        if (msg instanceof HttpRequest) {
            String expectValue;
            HttpRequest start = (HttpRequest)msg;
            HttpVersion protocol = start.protocolVersion();
            boolean requiredContentLengthValid = true;
            if (protocol.compareTo(HttpVersion.HTTP_1_1) >= 0 && (expectValue = start.headers().get((CharSequence)HttpHeaderNames.EXPECT)) != null) {
                if (HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase(expectValue)) {
                    if (this.isContentLengthInvalid((HttpMessage)start)) {
                        this.write413(ctx, true, TOO_LARGE.retainedDuplicate());
                        return;
                    }
                    requiredContentLengthValid = false;
                    this.write100(ctx);
                    start.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
                } else {
                    this.write417(ctx, this.isKeepAlive(start));
                    return;
                }
            }
            if (requiredContentLengthValid && this.isContentLengthInvalid((HttpMessage)start)) {
                boolean keepalive = this.isKeepAlive(start);
                FullHttpResponse tooLarge = keepalive ? TOO_LARGE : TOO_LARGE_CLOSE;
                this.write413(ctx, keepalive, tooLarge.retainedDuplicate());
                this.resetNow();
                return;
            }
            try {
                this.current = new Http1RequestHandleImpl(this.runtime, ctx, start, this.isKeepAlive(start));
                this.handler.accept(this.current);
                this.runtime.metrics().reportRequest(this.current);
            }
            catch (Throwable t) {
                this.error(t, null, req -> {
                    if (!req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(req.response(), t), false)) {
                        Loggers.logger().warn("Error while accepting {}", req, (Object)t);
                    }
                });
            }
        } else if (msg instanceof HttpContent) {
            if (this.current == null) {
                return;
            }
            if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
                this.end();
                return;
            }
            ByteBuf buf = ((HttpContent)msg).content();
            if (this.chunkSize >= 0L) {
                if ((long)buf.readableBytes() > this.chunkSize) {
                    buf = buf.readSlice((int)this.chunkSize);
                    this.handleData(buf);
                    TooLongFrameException t = new TooLongFrameException("content length exceeded " + this.runtime.options().getMaxContentLength() + " bytes.");
                    this.error((Throwable)t, r -> {
                        if (!r.response().tryEnd(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, () -> {
                            r.response().headers().clear();
                            return Unpooled.EMPTY_BUFFER;
                        }, false)) {
                            Loggers.logger().error("Request entity too large.", (Throwable)t);
                        }
                    }, null);
                    return;
                }
                this.chunkSize -= (long)buf.readableBytes();
            }
            if (!this.handleData(((HttpContent)msg).content())) {
                return;
            }
            if (msg instanceof LastHttpContent) {
                if (((LastHttpContent)msg).trailingHeaders().isEmpty()) {
                    if (this.handleTrailer((HttpHeaders)EmptyHttpHeaders.INSTANCE)) {
                        this.end();
                    }
                } else if (this.handleTrailer((HttpHeaders)new Http1HeadersAdaptor(((LastHttpContent)msg).trailingHeaders()))) {
                    this.end();
                }
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.current != null && !ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
        ctx.fireChannelReadComplete();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            super.channelInactive(ctx);
        }
        finally {
            this.handleChannelInactive(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        try {
            super.handlerRemoved(ctx);
        }
        finally {
            this.handleChannelInactive(ctx);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!Utils.handleIdle(ctx, evt)) {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.error(cause, r -> {
            if (!r.response().tryEndWithCrash(cause)) {
                Loggers.logger().warn("Unexpected channel exception caught, but {} has been committed", (Object)r.response(), (Object)ctx.channel());
            }
        }, null);
        Utils.handleException(ctx, cause);
    }

    private void decodeError(ChannelHandlerContext ctx, HttpObject msg) {
        Loggers.logger().error("{} decoding error", (Object)ctx.channel(), (Object)msg.decoderResult().cause());
        if (this.current == null) {
            this.write400(ctx, msg.decoderResult());
        } else {
            this.error(msg.decoderResult().cause(), r -> {
                if (!r.response().tryEnd(HttpResponseStatus.BAD_REQUEST, () -> {
                    ByteBuf err = Unpooled.copiedBuffer((byte[])msg.decoderResult().toString().getBytes(StandardCharsets.UTF_8));
                    r.response().headers().clear();
                    r.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
                    return err;
                }, true)) {
                    Loggers.logger().warn("Decoding error occurred, but {} has been committed", (Object)r.response(), (Object)msg.decoderResult().cause());
                }
            }, null);
        }
    }

    private boolean isKeepAlive(HttpRequest start) {
        return this.runtime.options().isKeepAliveEnable() && !this.runtime.shutdownStatus().get() && HttpUtil.isKeepAlive((HttpMessage)start);
    }

    private boolean handleData(ByteBuf data) {
        try {
            this.current.handleContent(data);
            return true;
        }
        catch (Throwable t) {
            this.error(t, null, req -> {
                if (!req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(req.response(), t), false)) {
                    Loggers.logger().warn("Error while handing content: {}", req, (Object)t);
                }
            });
            return false;
        }
    }

    private boolean handleTrailer(HttpHeaders trailer) {
        if (trailer != null && !trailer.isEmpty()) {
            try {
                this.current.handleTrailer(trailer);
                return true;
            }
            catch (Throwable t) {
                this.error(t, null, req -> {
                    if (!req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(req.response(), t), false)) {
                        Loggers.logger().warn("Error while handing trailers: {}", req, (Object)t);
                    }
                });
                return false;
            }
        }
        return true;
    }

    private void end() {
        assert (this.current != null);
        Http1RequestHandleImpl req = this.current;
        req.isEnded = true;
        try {
            req.handleEnd();
            this.resetNow();
        }
        catch (Throwable t) {
            this.error(t, null, r -> {
                if (req.response().tryEnd(HttpResponseStatus.INTERNAL_SERVER_ERROR, () -> Utils.toErrorMsg(req.response(), t), false)) {
                    Loggers.logger().warn("Error while handing {}", (Object)req, (Object)t);
                }
            });
        }
    }

    private void error(Throwable err, Consumer<Http1RequestHandleImpl> before, Consumer<Http1RequestHandleImpl> after) {
        Http1RequestHandleImpl req = this.current;
        if (req != null) {
            this.resetNow();
            if (before != null) {
                before.accept(req);
            }
            if (!req.isEnded) {
                req.isEnded = true;
            }
            Throwable causeToCloseChannel = null;
            try {
                req.handleError(err);
            }
            catch (Throwable t) {
                Loggers.logger().error("Error while handing {}, but another error was thrown by the onError() handler.", (Object)req, (Object)t);
                causeToCloseChannel = t;
            }
            if (after != null) {
                after.accept(req);
            }
            if (causeToCloseChannel != null && req.ctx.channel().isActive()) {
                req.ctx.channel().close();
            }
        }
    }

    private boolean isContentLengthInvalid(HttpMessage start) {
        if (this.runtime.options().getMaxContentLength() > 0L) {
            long contentLength;
            try {
                String value = start.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                contentLength = value != null ? Long.parseLong(value) : -1L;
            }
            catch (NumberFormatException e) {
                contentLength = -1L;
            }
            if (contentLength >= 0L) {
                return contentLength > this.runtime.options().getMaxContentLength();
            }
            this.chunkSize = this.runtime.options().getMaxContentLength();
            return false;
        }
        return false;
    }

    private void write100(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)CONTINUE.retainedDuplicate()).addListener(f -> {
            if (!f.isSuccess()) {
                Loggers.logger().warn("Failed to send a 100 Continue.", f.cause());
                ctx.channel().close();
            }
        });
    }

    private void write413(ChannelHandlerContext ctx, boolean keepalive, FullHttpResponse tooLarge) {
        ctx.writeAndFlush((Object)tooLarge).addListener(f -> {
            if (!f.isSuccess()) {
                Loggers.logger().warn("Failed to send a 413 Request Entity Too Large.", f.cause());
                ctx.channel().close();
            } else if (!keepalive) {
                ctx.channel().close();
            }
        });
        ctx.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
    }

    private void write417(ChannelHandlerContext ctx, boolean keepalive) {
        ctx.writeAndFlush((Object)EXPECTATION_FAILED.retainedDuplicate()).addListener(f -> {
            if (!f.isSuccess()) {
                Loggers.logger().warn("Failed to send a 417 Expectation Failed.", f.cause());
                ctx.channel().close();
            } else if (!keepalive) {
                ctx.channel().close();
            }
        });
        ctx.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
    }

    private void write400(ChannelHandlerContext ctx, DecoderResult msg) {
        ByteBuf err = Unpooled.copiedBuffer((byte[])msg.toString().getBytes(StandardCharsets.UTF_8));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, err);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)err.readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void handleChannelInactive(ChannelHandlerContext ctx) {
        if (this.current != null) {
            ChannelException t = new ChannelException("Channel " + ctx.channel() + " INACTIVE");
            this.error((Throwable)t, req -> {
                if (!req.response().tryEndWithCrash((Throwable)t)) {
                    Loggers.logger().warn("Channel {} inactive, but response has been committed", (Object)ctx.channel());
                }
            }, null);
        }
    }

    private void resetNow() {
        this.current = null;
        this.chunkSize = -1L;
    }

    static {
        EXPECTATION_FAILED.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        TOO_LARGE_CLOSE.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

