/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import io.esastack.httpserver.impl.Http2ChunkedInput;
import io.esastack.httpserver.impl.Utils;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.stream.ChunkedWriteHandler;

final class Http2ConnectionChunkHandler
extends Http2ConnectionHandler {
    Http2ConnectionChunkHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean decoupleCloseAndGoAway) {
        super(decoder, encoder, initialSettings, decoupleCloseAndGoAway);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.pipeline().addAfter(ctx.name(), "h2ChunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Http2ChunkedInput.Content) {
            boolean hasBody;
            Http2ChunkedInput.Content c = (Http2ChunkedInput.Content)((Object)msg);
            boolean bl = hasBody = c.content().readableBytes() > 0;
            if (hasBody) {
                if (msg instanceof Http2ChunkedInput.LastContent) {
                    Http2ChunkedInput.LastContent lastContent = (Http2ChunkedInput.LastContent)((Object)msg);
                    boolean hasTrailer = lastContent.trailers != null && !lastContent.trailers.isEmpty();
                    this.encoder().writeData(ctx, c.streamId, c.content(), 0, !hasTrailer, hasTrailer ? ctx.newPromise() : promise);
                    if (hasTrailer) {
                        this.encoder().writeHeaders(ctx, c.streamId, lastContent.trailers, lastContent.streamDependency, lastContent.weight, lastContent.exclusive, 0, true, promise);
                    }
                } else {
                    this.encoder().writeData(ctx, c.streamId, c.content(), 0, false, promise);
                }
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!Utils.handleIdle(ctx, evt)) {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause) != null) {
            super.exceptionCaught(ctx, cause);
        } else {
            Utils.handleException(ctx, cause);
        }
    }
}

