/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.function.Consumer3;
import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpserver.H2Options;
import io.esastack.httpserver.HAProxyMode;
import io.esastack.httpserver.ServerOptions;
import io.esastack.httpserver.core.RequestHandle;
import io.esastack.httpserver.impl.AggregatedLastHttpContent;
import io.esastack.httpserver.impl.H2cDetector;
import io.esastack.httpserver.impl.HAProxyDetector;
import io.esastack.httpserver.impl.HAProxyMessageHandler;
import io.esastack.httpserver.impl.Http1Handler;
import io.esastack.httpserver.impl.Http2ConnectionChunkHandler;
import io.esastack.httpserver.impl.Http2ConnectionChunkHandlerBuilder;
import io.esastack.httpserver.impl.Http2Handler;
import io.esastack.httpserver.impl.OnChannelActiveHandler;
import io.esastack.httpserver.impl.RequestDecoder;
import io.esastack.httpserver.impl.ServerRuntime;
import io.esastack.httpserver.impl.SslDetector;
import io.esastack.httpserver.impl.SslHelper;
import io.esastack.httpserver.utils.Constants;
import io.esastack.httpserver.utils.Loggers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import java.util.List;
import java.util.function.Consumer;

final class HttpServerChannelInitializr
extends ChannelInitializer<Channel> {
    private final ServerRuntime runtime;
    private final SslHelper sslHelper;
    private final Consumer<RequestHandle> handler;
    private final Consumer<Channel> onConnectionInit;
    private final Consumer<Channel> onConnected;
    private final Consumer<Channel> onDisconnected;

    HttpServerChannelInitializr(ServerRuntime runtime, SslHelper sslHelper, Consumer<RequestHandle> handler, Consumer<Channel> onConnectionInit, Consumer<Channel> onConnected, Consumer<Channel> onDisconnected) {
        this.runtime = runtime;
        this.sslHelper = sslHelper;
        this.handler = handler;
        this.onConnectionInit = onConnectionInit;
        this.onConnected = onConnected;
        this.onDisconnected = onDisconnected;
    }

    protected void initChannel(Channel ch) {
        HAProxyMode haProxyMode;
        if (!this.runtime.isRunning()) {
            ch.close();
            return;
        }
        if (this.onConnectionInit != null) {
            try {
                this.onConnectionInit.accept(ch);
            }
            catch (Throwable t) {
                Loggers.logger().warn("Error while processing onConnectionInit()", t);
            }
        }
        ChannelPipeline pipeline = ch.pipeline();
        this.applyChannelOptions(ch);
        if (Loggers.logger().isDebugEnabled() || this.onConnected != null || this.runtime.metrics().enabled()) {
            pipeline.addLast(new ChannelHandler[]{new OnChannelActiveHandler(ctx -> {
                if (Loggers.logger().isDebugEnabled()) {
                    Loggers.logger().debug("Received connection {}", (Object)ctx.channel());
                }
                if (this.onConnected != null) {
                    try {
                        this.onConnected.accept(ch);
                    }
                    catch (Throwable t) {
                        Loggers.logger().warn("Error while processing onConnected()", t);
                    }
                }
                ctx.channel().closeFuture().addListener(f -> {
                    if (Loggers.logger().isDebugEnabled()) {
                        Loggers.logger().debug("Connection Disconnected {}", (Object)ctx.channel());
                    }
                    if (this.onDisconnected != null) {
                        try {
                            this.onDisconnected.accept(ctx.channel());
                        }
                        catch (Throwable t) {
                            Loggers.logger().warn("Error while processing onDisconnected()", t);
                        }
                    }
                    this.runtime.metrics().reportDisconnect(ch);
                });
            })});
        }
        if ((haProxyMode = this.options().getHaProxy()) != null && !HAProxyMode.OFF.equals((Object)haProxyMode)) {
            if (HAProxyMode.ON.equals((Object)haProxyMode)) {
                pipeline.addFirst("HAProxyDecoder", (ChannelHandler)new HAProxyMessageDecoder());
                pipeline.addAfter("HAProxyDecoder", "HAProxyMessageHandler", (ChannelHandler)new HAProxyMessageHandler());
            } else {
                pipeline.addFirst("HAProxyDetector", (ChannelHandler)new HAProxyDetector());
            }
        }
        if (this.sslHelper.isSsl()) {
            pipeline.addLast("SslDetector", (ChannelHandler)new SslDetector(this.sslHelper, (Consumer3<Boolean, Channel, Throwable>)((Consumer3)(isSsl, channel, err) -> {
                SslHandler sslHandler;
                if (err != null) {
                    Loggers.logger().error("{} TLS handshake failed", channel, err);
                    channel.close();
                    return;
                }
                if (isSsl.booleanValue()) {
                    channel.attr(Constants.SCHEME).set((Object)"https");
                } else {
                    channel.attr(Constants.SCHEME).set((Object)"http");
                }
                this.addCustomHandlers(channel.pipeline());
                if (this.sslHelper.isSsl() && (sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class)) != null && "h2".equals(sslHandler.applicationProtocol())) {
                    this.addHttp2Handlers((Channel)channel);
                } else if (this.options().getH2() != null && this.options().getH2().isEnabled()) {
                    this.addUpgradeHandler((Channel)channel);
                } else {
                    this.addHttp1Handlers(pipeline);
                    this.addHttp1Handler(ch);
                }
            })));
        } else {
            ch.attr(Constants.SCHEME).set((Object)"http");
            this.addCustomHandlers(pipeline);
            if (this.options().getH2() != null && this.options().getH2().isEnabled()) {
                this.addH1OrH2cHandler(pipeline);
            } else {
                this.addHttp1Handlers(pipeline);
                this.addHttp1Handler(ch);
            }
        }
    }

    private void applyChannelOptions(Channel ch) {
        int high = this.options().getWriteBufferHighWaterMark();
        int low = this.options().getWriteBufferLowWaterMark();
        if (high > 0) {
            if (low > 0) {
                ch.config().setWriteBufferWaterMark(new WriteBufferWaterMark(low, high));
            } else {
                ch.config().setWriteBufferHighWaterMark(high);
            }
        } else if (low > 0) {
            ch.config().setWriteBufferLowWaterMark(low);
        }
    }

    private void addCustomHandlers(ChannelPipeline pipeline) {
        List<ChannelHandler> handlers;
        if (this.options().getLogging() != null) {
            pipeline.addFirst("Logging", (ChannelHandler)new LoggingHandler(this.options().getLogging()));
        }
        if ((handlers = this.options().getChannelHandlers()) != null && !handlers.isEmpty()) {
            pipeline.addLast(handlers.toArray(new ChannelHandler[0]));
        }
    }

    private void addHttp1Handlers(ChannelPipeline pipeline) {
        pipeline.addLast("RequestDecoder", (ChannelHandler)new RequestDecoder(this.options().getMaxInitialLineLength(), this.options().getMaxHeaderSize(), this.options().getMaxChunkSize()));
        pipeline.addLast("ResponseEncoder", (ChannelHandler)new HttpResponseEncoder());
        if (this.options().isDecompress()) {
            pipeline.addLast("Decompressor", (ChannelHandler)new HttpContentDecompressor());
        }
        if (this.options().isCompress()) {
            pipeline.addLast("Compressor", (ChannelHandler)new HttpContentCompressor(this.options().getCompressionLevel()));
        }
        if (this.sslHelper.isSsl() || this.options().isCompress()) {
            pipeline.addLast("ChunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (this.options().getIdleTimeoutSeconds() > 0) {
            pipeline.addLast("IdleHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.options().getIdleTimeoutSeconds()));
        }
    }

    private void addHttp1Handler(Channel ch) {
        ch.pipeline().addLast("H1Handler", (ChannelHandler)new Http1Handler(this.runtime, this.handler));
        this.runtime.metrics().reportConnect(ch, HttpVersion.HTTP_1_1);
    }

    private void addHttp2Handlers(Channel ch) {
        if (this.options().getIdleTimeoutSeconds() > 0) {
            ch.pipeline().addLast("IdleHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.options().getIdleTimeoutSeconds()));
        }
        ch.pipeline().addLast("H2Handler", (ChannelHandler)this.buildHttp2ConnectionHandler());
        this.runtime.metrics().reportConnect(ch, HttpVersion.HTTP_2);
    }

    private void addH1OrH2cHandler(ChannelPipeline pipeline) {
        pipeline.addLast("H2cDetector", (ChannelHandler)new H2cDetector((ctx, h2c) -> {
            if (h2c.booleanValue()) {
                this.addHttp2Handlers(ctx.channel());
            } else {
                this.addUpgradeHandler(ctx.channel());
            }
        }));
    }

    private void addUpgradeHandler(Channel channel) {
        this.addHttp1Handlers(channel.pipeline());
        channel.pipeline().addLast("UpgradeHandler", (ChannelHandler)new HttpServerUpgradeHandler(fromCtx -> {
            fromCtx.pipeline().remove("RequestDecoder");
            fromCtx.pipeline().remove("ResponseEncoder");
            if (this.options().isDecompress()) {
                fromCtx.pipeline().remove("Decompressor");
            }
            if (this.options().isCompress()) {
                fromCtx.pipeline().remove("Compressor");
            }
            if (this.sslHelper.isSsl() || this.options().isCompress()) {
                fromCtx.pipeline().remove("ChunkedWriter");
            }
            fromCtx.pipeline().remove("H1Handler");
            fromCtx.pipeline().remove("Splitter");
            this.runtime.metrics().reportUpgrade(fromCtx.channel());
        }, protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec("H2Handler", (Http2ConnectionHandler)this.buildHttp2ConnectionHandler());
            }
            if (Loggers.logger().isDebugEnabled()) {
                Loggers.logger().debug("Unsupported upgrade protocol: {}", (Object)protocol);
            }
            return null;
        }, this.maxContentLength()));
        channel.pipeline().addLast("Splitter", (ChannelHandler)new MessageToMessageDecoder<FullHttpRequest>(){

            protected void decode(ChannelHandlerContext ctx, FullHttpRequest msg, List<Object> out) {
                out.add(msg.retain());
                if (msg.content().isReadable()) {
                    out.add(new AggregatedLastHttpContent(msg.content().retain(), msg.trailingHeaders()));
                } else {
                    out.add(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        });
        this.addHttp1Handler(channel);
    }

    private int maxContentLength() {
        long configured = this.runtime.options().getMaxContentLength();
        return configured > 0L && configured < Integer.MAX_VALUE ? (int)configured : Integer.MAX_VALUE;
    }

    private Http2ConnectionChunkHandler buildHttp2ConnectionHandler() {
        H2Options h2Options = this.options().getH2();
        assert (h2Options != null);
        DefaultHttp2Connection connection = h2Options.getMaxReservedStreams() > 0 ? new DefaultHttp2Connection(true, h2Options.getMaxReservedStreams()) : new DefaultHttp2Connection(true);
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader();
        if (Http2CodecUtil.isMaxFrameSizeValid((int)h2Options.getMaxFrameSize())) {
            try {
                writer.maxFrameSize(h2Options.getMaxFrameSize());
                reader.maxFrameSize(h2Options.getMaxFrameSize());
            }
            catch (Http2Exception http2Exception) {
                // empty catch block
            }
        }
        if (this.options().getLogging() != null) {
            reader = new Http2InboundFrameLogger((Http2FrameReader)reader, new Http2FrameLogger(this.options().getLogging()));
            writer = new Http2OutboundFrameLogger((Http2FrameWriter)writer, new Http2FrameLogger(this.options().getLogging()));
        }
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, (Http2FrameWriter)writer);
        if (this.options().isCompress()) {
            encoder = new CompressorHttp2ConnectionEncoder((Http2ConnectionEncoder)encoder, this.options().getCompressionLevel(), 15, 8);
        }
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        Http2Handler frameListener = new Http2Handler(this.runtime, (Http2ConnectionEncoder)encoder, this.handler);
        Http2ConnectionChunkHandlerBuilder builder = new Http2ConnectionChunkHandlerBuilder().codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder).frameListener((Http2FrameListener)(this.options().isDecompress() ? new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)frameListener) : frameListener));
        if (h2Options.getGracefulShutdownTimeoutMillis() > 0L) {
            builder.gracefulShutdownTimeoutMillis(h2Options.getGracefulShutdownTimeoutMillis());
        }
        return builder.build();
    }

    private ServerOptions options() {
        return this.runtime.options();
    }
}

