/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.Checks;
import io.esastack.httpserver.core.MultipartFile;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.multipart.FileUpload;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

final class MultipartFileImpl
implements MultipartFile {
    private final FileUpload upload;

    MultipartFileImpl(FileUpload upload) {
        Checks.checkNotNull((Object)upload, (String)"upload");
        this.upload = upload;
    }

    @Override
    public String name() {
        return this.upload.getName();
    }

    @Override
    public String fileName() {
        return this.upload.getFilename();
    }

    @Override
    public String contentType() {
        return this.upload.getContentType();
    }

    @Override
    public long length() {
        return this.upload.length();
    }

    @Override
    public String contentTransferEncoding() {
        return this.upload.getContentTransferEncoding();
    }

    @Override
    public boolean isInMemory() {
        return this.upload.isInMemory();
    }

    @Override
    public File file() throws IOException {
        return this.upload.getFile();
    }

    @Override
    public ByteBuf getByteBuf() throws IOException {
        return this.upload.getByteBuf();
    }

    @Override
    public void transferTo(File dest) throws IOException {
        this.upload.renameTo(dest);
    }

    @Override
    public String string() throws IOException {
        return this.upload.getString();
    }

    @Override
    public String string(Charset charset) throws IOException {
        return this.upload.getString(charset);
    }

    @Override
    public void delete() {
        this.upload.delete();
    }
}

