/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.ExceptionUtils;
import esa.commons.collection.LinkedMultiValueMap;
import esa.commons.collection.MultiMaps;
import esa.commons.collection.MultiValueMap;
import io.esastack.httpserver.core.MultiPart;
import io.esastack.httpserver.core.MultipartFile;
import io.esastack.httpserver.impl.MultipartFileImpl;
import io.esastack.httpserver.utils.Loggers;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class MultipartHandle
implements MultiPart {
    static final Empty EMPTY = new Empty();
    private final HttpPostRequestDecoder decoder;
    private List<MultipartFile> files;
    private MultiValueMap<String, String> attrs;

    MultipartHandle(HttpPostRequestDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public List<MultipartFile> uploadFiles() {
        if (this.files == null) {
            return EMPTY.uploadFiles();
        }
        return this.files;
    }

    @Override
    public MultiValueMap<String, String> attributes() {
        if (this.attrs == null) {
            return EMPTY.attributes();
        }
        return this.attrs;
    }

    void onData(ByteBuf buf) {
        this.decoder.offer((HttpContent)new DefaultHttpContent(buf));
    }

    void end() {
        LinkedList<MultipartFileImpl> files = null;
        LinkedMultiValueMap attrs = null;
        try {
            this.decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
            List decoded = this.decoder.getBodyHttpDatas();
            for (InterfaceHttpData data : decoded) {
                if (InterfaceHttpData.HttpDataType.Attribute.equals((Object)data.getHttpDataType())) {
                    Attribute attr = (Attribute)data;
                    if (attrs == null) {
                        attrs = new LinkedMultiValueMap();
                    }
                    attrs.add((Object)attr.getName(), (Object)attr.getValue());
                    continue;
                }
                if (!InterfaceHttpData.HttpDataType.FileUpload.equals((Object)data.getHttpDataType())) continue;
                if (files == null) {
                    files = new LinkedList<MultipartFileImpl>();
                }
                files.add(new MultipartFileImpl((FileUpload)data));
            }
            if (files != null) {
                this.files = files;
            }
            if (attrs != null) {
                this.attrs = attrs;
            }
        }
        catch (IOException e) {
            ExceptionUtils.throwException((Throwable)e);
        }
    }

    void release() {
        try {
            this.decoder.destroy();
        }
        catch (Exception e) {
            Loggers.logger().warn("Unexpected error while releasing multipart resources", (Throwable)e);
        }
    }

    private static class Empty
    implements MultiPart {
        private Empty() {
        }

        @Override
        public List<MultipartFile> uploadFiles() {
            return Collections.emptyList();
        }

        @Override
        public MultiValueMap<String, String> attributes() {
            return MultiMaps.emptyMultiMap();
        }
    }
}

