/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.Checks;
import io.esastack.httpserver.utils.Loggers;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.function.Consumer;

final class OnChannelActiveHandler
extends ChannelInboundHandlerAdapter {
    private final Consumer<ChannelHandlerContext> onConnect;

    OnChannelActiveHandler(Consumer<ChannelHandlerContext> onConnect) {
        Checks.checkNotNull(onConnect, (String)"onConnect");
        this.onConnect = onConnect;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.onConnect.accept(ctx);
        }
        catch (Throwable t) {
            Loggers.logger().error("Error while processing onConnect handler.", t);
        }
        ctx.pipeline().remove((ChannelHandler)this);
        super.channelActive(ctx);
    }
}

