/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.Checks;
import esa.commons.StringUtils;
import io.esastack.httpserver.MultipartOptions;
import io.esastack.httpserver.MultipartOptionsConfigure;
import io.esastack.httpserver.ServerOptions;
import io.esastack.httpserver.impl.HttpServerImpl;
import io.esastack.httpserver.metrics.impl.MetricsImpl;
import io.esastack.httpserver.metrics.impl.MetricsReporter;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerRuntime
extends DefaultAttributeMap {
    private final String name;
    private final ServerOptions options;
    private final AtomicBoolean shutdownStatus = new AtomicBoolean(false);
    private final MetricsReporter metrics;
    private final HttpServerImpl.CloseFuture closeFuture;
    private volatile HttpDataFactory multipartDataFactory;
    private volatile Running running;

    ServerRuntime(String name, ServerOptions options, HttpServerImpl.CloseFuture closeFuture) {
        this.closeFuture = closeFuture;
        Checks.checkNotEmptyArg((String)name, (String)"name");
        Checks.checkNotNull((Object)options, (String)"options");
        Checks.checkNotNull((Object)this.shutdownStatus, (String)"shutdownStatus");
        this.name = name;
        this.options = new ServerOptions(options);
        this.metrics = MetricsImpl.of(options.isMetricsEnabled());
    }

    public String name() {
        return this.name;
    }

    public ServerOptions options() {
        return this.options;
    }

    public AtomicBoolean shutdownStatus() {
        return this.shutdownStatus;
    }

    public MetricsReporter metrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpDataFactory multipartDataFactory() {
        if (this.multipartDataFactory == null) {
            ServerRuntime serverRuntime = this;
            synchronized (serverRuntime) {
                if (this.multipartDataFactory == null) {
                    this.multipartDataFactory = this.buildMultipartDataFactory();
                }
            }
        }
        return this.multipartDataFactory;
    }

    public boolean isRunning() {
        return this.running != null;
    }

    public SocketAddress address() {
        Running status = this.running;
        return status == null ? null : status.address;
    }

    public EventLoopGroup bossGroup() {
        Running status = this.running;
        return status == null ? null : status.bossGroup;
    }

    public EventLoopGroup ioGroup() {
        Running status = this.running;
        return status == null ? null : status.ioGroup;
    }

    public Future<Void> closeFuture() {
        return this.closeFuture;
    }

    void setStarted(SocketAddress address, EventLoopGroup bossGroup, EventLoopGroup ioGroup) {
        this.running = new Running(address, bossGroup, ioGroup);
    }

    Running setClosed() {
        this.shutdownStatus.set(true);
        Running status = this.running;
        this.running = null;
        return status;
    }

    private HttpDataFactory buildMultipartDataFactory() {
        MultipartOptions config = this.options().getMultipart();
        if (config == null) {
            config = MultipartOptionsConfigure.newOpts().configured();
        }
        DefaultHttpDataFactory factory = config.isUseDisk() ? new DefaultHttpDataFactory(config.isUseDisk(), config.getCharset()) : new DefaultHttpDataFactory(config.getMemoryThreshold(), config.getCharset());
        factory.setMaxLimit(config.getMaxSize());
        String tempDir = config.getTempDir();
        if (StringUtils.isNotEmpty((String)tempDir)) {
            DiskFileUpload.baseDirectory = tempDir;
        }
        return factory;
    }

    static final class Running {
        final SocketAddress address;
        final EventLoopGroup bossGroup;
        final EventLoopGroup ioGroup;

        private Running(SocketAddress address, EventLoopGroup bossGroup, EventLoopGroup ioGroup) {
            this.address = address;
            this.bossGroup = bossGroup;
            this.ioGroup = ioGroup;
        }
    }
}

