/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.impl;

import esa.commons.ExceptionUtils;
import io.esastack.httpserver.SslOptions;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.util.Arrays;
import javax.net.ssl.SSLException;

final class SslHelper {
    private final SslOptions ssl;
    private final SslContext sslContext;

    SslHelper(SslOptions ssl, boolean isH2Enabled) {
        this.ssl = ssl;
        this.sslContext = this.createContext(isH2Enabled);
    }

    private SslContext createContext(boolean isH2Enabled) {
        if (!this.isSsl()) {
            return null;
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((File)this.ssl.getCertificate(), (File)this.ssl.getPrivateKey(), (String)this.ssl.getKeyPassword());
        sslContextBuilder.sslProvider(SslHelper.detectSslProvider());
        if (isH2Enabled) {
            sslContextBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        }
        if (this.ssl.getClientAuth() != null) {
            sslContextBuilder.clientAuth(this.ssl.getClientAuth());
        }
        if (this.ssl.getSessionTimeout() > 0L) {
            sslContextBuilder.sessionTimeout(this.ssl.getSessionTimeout());
        }
        if (this.ssl.getSessionCacheSize() > 0L) {
            sslContextBuilder.sessionCacheSize(this.ssl.getSessionCacheSize());
        }
        if (this.ssl.getCiphers() != null && this.ssl.getCiphers().length > 0) {
            sslContextBuilder.ciphers(Arrays.asList(this.ssl.getCiphers()));
        }
        if (this.ssl.getTrustCertificates() != null) {
            sslContextBuilder.trustManager(this.ssl.getTrustCertificates());
        }
        try {
            return sslContextBuilder.build();
        }
        catch (SSLException e) {
            throw ExceptionUtils.asRuntime((Throwable)e);
        }
    }

    boolean isSsl() {
        return this.ssl != null;
    }

    SslOptions options() {
        return this.ssl;
    }

    SslContext getSslContext() {
        return this.sslContext;
    }

    private static SslProvider detectSslProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        return SslProvider.JDK;
    }
}

