/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.metrics.impl;

import io.esastack.httpserver.metrics.ConnectionMetrics;
import java.util.concurrent.atomic.LongAdder;

final class ConnectionMetricsImpl
implements ConnectionMetrics {
    static final ConnectionMetrics DISABLED = new Disabled();
    private static final int HTTP_VERSION_SHIFT = 32;
    private static final long HTTP1_UNIT = 0x100000000L;
    private static final long HTTP2_MASK = 0xFFFFFFFFL;
    private static final int HTTP_SCHEMA_SHIFT = 32;
    private static final long HTTP_UNIT = 0x100000000L;
    private static final long HTTPS_MASK = 0xFFFFFFFFL;
    private final LongAdder activeHttpVersionState = new LongAdder();
    private final LongAdder activeHttpSchemaState = new LongAdder();
    final LongAdder http1ConnectionCount = new LongAdder();
    final LongAdder http2ConnectionCount = new LongAdder();
    final LongAdder httpConnectionCount = new LongAdder();
    final LongAdder httpsConnectionCount = new LongAdder();

    ConnectionMetricsImpl() {
    }

    @Override
    public long activeHttp1Connections() {
        return this.activeHttpVersionState.sum() >>> 32;
    }

    @Override
    public long activeHttp2Connections() {
        return this.activeHttpVersionState.sum() & 0xFFFFFFFFL;
    }

    @Override
    public long activeHttpConnections() {
        return this.activeHttpSchemaState.sum() >>> 32;
    }

    @Override
    public long activeHttpsConnections() {
        return this.activeHttpSchemaState.sum() & 0xFFFFFFFFL;
    }

    @Override
    public long http1ConnectionCount() {
        return this.http1ConnectionCount.sum();
    }

    @Override
    public long http2ConnectionCount() {
        return this.http2ConnectionCount.sum();
    }

    @Override
    public long httpConnectionCount() {
        return this.httpConnectionCount.sum();
    }

    @Override
    public long httpsConnectionCount() {
        return this.httpsConnectionCount.sum();
    }

    void incrementActiveHttp1Connections() {
        this.activeHttpVersionState.add(0x100000000L);
    }

    void decrementActiveHttp1Connections() {
        this.activeHttpVersionState.add(-4294967296L);
    }

    void incrementActiveHttp2Connections() {
        this.activeHttpVersionState.add(1L);
    }

    void decrementActiveHttp2Connections() {
        this.activeHttpVersionState.add(-1L);
    }

    void incrementActiveHttpConnections() {
        this.activeHttpSchemaState.add(0x100000000L);
    }

    void decrementActiveHttpConnections() {
        this.activeHttpSchemaState.add(-4294967296L);
    }

    void incrementActiveHttpsConnections() {
        this.activeHttpSchemaState.add(1L);
    }

    void decrementActiveHttpsConnections() {
        this.activeHttpSchemaState.add(-1L);
    }

    private static class Disabled
    implements ConnectionMetrics {
        private Disabled() {
        }

        @Override
        public long activeHttp1Connections() {
            return 0L;
        }

        @Override
        public long activeHttp2Connections() {
            return 0L;
        }

        @Override
        public long activeHttpsConnections() {
            return 0L;
        }

        @Override
        public long activeHttpConnections() {
            return 0L;
        }

        @Override
        public long http1ConnectionCount() {
            return 0L;
        }

        @Override
        public long http2ConnectionCount() {
            return 0L;
        }

        @Override
        public long httpConnectionCount() {
            return 0L;
        }

        @Override
        public long httpsConnectionCount() {
            return 0L;
        }

        @Override
        public long activeConnections() {
            return 0L;
        }

        @Override
        public long connectionCount() {
            return 0L;
        }
    }
}

