/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.metrics.impl;

import io.esastack.commons.net.http.HttpVersion;
import io.esastack.httpserver.core.BaseRequest;
import io.esastack.httpserver.metrics.ConnectionMetrics;
import io.esastack.httpserver.metrics.Metrics;
import io.esastack.httpserver.metrics.OpenSslSessionMetrics;
import io.esastack.httpserver.metrics.RequestMetrics;
import io.esastack.httpserver.metrics.impl.ConnectionMetricsImpl;
import io.esastack.httpserver.metrics.impl.MetricsReporter;
import io.esastack.httpserver.metrics.impl.OpenSslSessionMetricsImpl;
import io.esastack.httpserver.metrics.impl.RequestMetricsImpl;
import io.esastack.httpserver.utils.Constants;
import io.netty.channel.Channel;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;

public final class MetricsImpl
implements MetricsReporter {
    private static final Disabled DISABLED = new Disabled();
    private static final AttributeKey<HttpVersion> HTTP_VERSION = AttributeKey.valueOf((String)"$http.version");
    private final ConnectionMetricsImpl connectionMetrics = new ConnectionMetricsImpl();
    private final RequestMetricsImpl requestMetrics = new RequestMetricsImpl();
    private volatile OpenSslSessionMetricsImpl openSslSessionMetrics;

    public static MetricsReporter of(boolean enabled) {
        return enabled ? new MetricsImpl() : DISABLED;
    }

    private MetricsImpl() {
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public RequestMetrics request() {
        return this.requestMetrics;
    }

    @Override
    public ConnectionMetrics connection() {
        return this.connectionMetrics;
    }

    @Override
    public OpenSslSessionMetrics openSslSession() {
        return this.openSslSessionMetrics == null ? OpenSslSessionMetricsImpl.DISABLED : this.openSslSessionMetrics;
    }

    @Override
    public void reportConnect(Channel ch, HttpVersion httpVersion) {
        ch.attr(HTTP_VERSION).set((Object)httpVersion);
        if (HttpVersion.HTTP_2 == httpVersion) {
            this.connectionMetrics.incrementActiveHttp2Connections();
            this.connectionMetrics.http2ConnectionCount.increment();
        } else {
            this.connectionMetrics.incrementActiveHttp1Connections();
            this.connectionMetrics.http1ConnectionCount.increment();
        }
        if (MetricsImpl.isHttps(ch)) {
            this.connectionMetrics.incrementActiveHttpsConnections();
            this.connectionMetrics.httpsConnectionCount.increment();
        } else {
            this.connectionMetrics.incrementActiveHttpConnections();
            this.connectionMetrics.httpConnectionCount.increment();
        }
    }

    @Override
    public void reportDisconnect(Channel ch) {
        HttpVersion version = (HttpVersion)ch.attr(HTTP_VERSION).get();
        if (version != null) {
            if (HttpVersion.HTTP_2 == version) {
                this.connectionMetrics.decrementActiveHttp2Connections();
            } else {
                this.connectionMetrics.decrementActiveHttp1Connections();
            }
        }
        if (MetricsImpl.isHttps(ch)) {
            this.connectionMetrics.decrementActiveHttpsConnections();
        } else {
            this.connectionMetrics.decrementActiveHttpConnections();
        }
    }

    @Override
    public void reportUpgrade(Channel ch) {
        ch.attr(HTTP_VERSION).set((Object)HttpVersion.HTTP_2);
        this.connectionMetrics.incrementActiveHttp2Connections();
        this.connectionMetrics.decrementActiveHttp1Connections();
    }

    @Override
    public void reportRequest(BaseRequest request) {
        this.requestMetrics.requestCount.increment();
    }

    @Override
    public void initSsl(SslContext context) {
        if (context instanceof OpenSslServerContext) {
            OpenSslServerContext openSslServerContext = (OpenSslServerContext)context;
            this.openSslSessionMetrics = new OpenSslSessionMetricsImpl(openSslServerContext.sessionContext().stats());
        }
    }

    private static boolean isHttps(Channel ch) {
        String schema = (String)ch.attr(Constants.SCHEME).get();
        return schema != null && "https".equals(schema);
    }

    private static class Disabled
    implements Metrics,
    MetricsReporter {
        private Disabled() {
        }

        @Override
        public boolean enabled() {
            return false;
        }

        @Override
        public RequestMetrics request() {
            return RequestMetricsImpl.DISABLED;
        }

        @Override
        public ConnectionMetrics connection() {
            return ConnectionMetricsImpl.DISABLED;
        }

        @Override
        public OpenSslSessionMetrics openSslSession() {
            return OpenSslSessionMetricsImpl.DISABLED;
        }

        @Override
        public void reportConnect(Channel ch, HttpVersion httpVersion) {
        }

        @Override
        public void reportDisconnect(Channel ch) {
        }

        @Override
        public void reportUpgrade(Channel ch) {
        }

        @Override
        public void reportRequest(BaseRequest request) {
        }

        @Override
        public void initSsl(SslContext context) {
        }
    }
}

