/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.transport;

import esa.commons.Checks;
import io.esastack.httpserver.NetOptions;
import io.esastack.httpserver.transport.Transport;
import io.esastack.httpserver.utils.Loggers;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadFactory;

public class NioTransport
implements Transport {
    static NioTransport INSTANCE = new NioTransport();
    private static final boolean USE_UNPOOLED_ALLOCATOR = SystemPropertyUtil.getBoolean((String)"io.esastack.httpserver.useUnpooledAllocator", (boolean)false);

    @Override
    public ChannelFactory<ServerChannel> serverChannelFactory(SocketAddress local) {
        Checks.checkArg((!(local instanceof DomainSocketAddress) ? 1 : 0) != 0, (String)"Domain socket is UNSUPPORTED in NIO transport");
        return NioServerSocketChannel::new;
    }

    @Override
    public EventLoopGroup loop(int nThreads, ThreadFactory threadFactory) {
        return new NioEventLoopGroup(nThreads, threadFactory);
    }

    @Override
    public void applyOptions(ServerBootstrap bootstrap, NetOptions options, SocketAddress local) {
        boolean isDomainSocket = local instanceof DomainSocketAddress;
        if (!isDomainSocket) {
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)options.isSoKeepalive());
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)options.isTcpNoDelay());
        }
        if (options.getSoBacklog() > 0) {
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)options.getSoBacklog());
        }
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)options.isReuseAddress());
        if (USE_UNPOOLED_ALLOCATOR) {
            bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        if (options.getSoRcvbuf() > 0) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)options.getSoRcvbuf());
        }
        if (options.getSoSendbuf() > 0) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)options.getSoSendbuf());
        }
        if (options.getSoLinger() != -1) {
            bootstrap.childOption(ChannelOption.SO_LINGER, (Object)options.getSoLinger());
        }
        if (options.getOptions() != null) {
            NioTransport.addOption((AbstractBootstrap)bootstrap, options.getOptions());
        }
        if (options.getChildOptions() != null) {
            NioTransport.addChildOption(bootstrap, options.getChildOptions());
        }
    }

    private static void addOption(AbstractBootstrap bootstrap, Map<ChannelOption<?>, Object> options) {
        if (!options.isEmpty()) {
            for (Map.Entry<ChannelOption<?>, Object> entry : options.entrySet()) {
                bootstrap.option(entry.getKey(), entry.getValue());
            }
        }
    }

    private static void addChildOption(ServerBootstrap bootstrap, Map<ChannelOption<?>, Object> options) {
        if (!options.isEmpty()) {
            for (Map.Entry<ChannelOption<?>, Object> entry : options.entrySet()) {
                bootstrap.childOption(entry.getKey(), entry.getValue());
            }
        }
    }

    static {
        if (Loggers.logger().isDebugEnabled()) {
            Loggers.logger().debug("-Dio.esastack.httpserver.useUnpooledAllocator: {}", (Object)USE_UNPOOLED_ALLOCATOR);
        }
    }
}

