/*
 * Decompiled with CFR 0.152.
 */
package io.esastack.httpserver.utils;

import esa.commons.Checks;
import esa.commons.concurrent.InternalThreads;
import io.esastack.httpserver.utils.Loggers;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class LoggedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_ID = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;

    public LoggedThreadFactory(String prefix) {
        this(prefix, false);
    }

    public LoggedThreadFactory(String prefix, boolean daemon) {
        Checks.checkNotNull((Object)prefix, (String)"prefix");
        this.prefix = prefix + "-" + POOL_ID.getAndIncrement() + "#";
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.prefix + this.nextId.getAndIncrement();
        Thread t = InternalThreads.newThread((Runnable)r, (String)name).thread();
        try {
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Loggers.logger().info("Create thread of ESA HttpServer '{}'", (Object)name);
        return t;
    }
}

