/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.LocalizedIntegers;
import io.fusionauth.domain.User;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.ExcludeFromDatabaseDataColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Consent
implements Buildable<Consent>,
_InternalJSONColumn {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID consentEmailTemplateId;
    @InternalJSONColumn
    public LocalizedIntegers countryMinimumAgeForSelfConsent = new LocalizedIntegers();
    @InternalJSONColumn
    public Integer defaultMinimumAgeForSelfConsent;
    @InternalJSONColumn
    public EmailPlus emailPlus = new EmailPlus();
    public UUID id;
    @InternalJSONColumn
    public boolean multipleValuesAllowed;
    public String name;
    @InternalJSONColumn
    public List<String> values = new ArrayList<String>();

    @JacksonConstructor
    public Consent() {
    }

    @JsonIgnore
    public boolean canSelfConsent(User user) {
        Integer ageOfSelfConsent = this.getMinimumSelfConsentAge(user);
        if (ageOfSelfConsent == 0) {
            return true;
        }
        return user.getAge() >= ageOfSelfConsent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Consent)) {
            return false;
        }
        Consent that = (Consent)o;
        return this.multipleValuesAllowed == that.multipleValuesAllowed && Objects.equals(this.data, that.data) && Objects.equals(this.consentEmailTemplateId, that.consentEmailTemplateId) && Objects.equals(this.countryMinimumAgeForSelfConsent, that.countryMinimumAgeForSelfConsent) && Objects.equals(this.defaultMinimumAgeForSelfConsent, that.defaultMinimumAgeForSelfConsent) && Objects.equals(this.emailPlus, that.emailPlus) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
    }

    @JsonIgnore
    public Integer getMinimumSelfConsentAge(User user) {
        for (Locale locale : user.preferredLanguages) {
            Integer override = (Integer)this.countryMinimumAgeForSelfConsent.get(locale);
            if (override == null) continue;
            return override;
        }
        return this.defaultMinimumAgeForSelfConsent;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.consentEmailTemplateId, this.countryMinimumAgeForSelfConsent, this.defaultMinimumAgeForSelfConsent, this.emailPlus, this.id, this.multipleValuesAllowed, this.name, this.values);
    }

    public void normalize() {
        if (this.values != null) {
            Normalizer.removeEmpty(this.values);
        }
        if (this.countryMinimumAgeForSelfConsent != null) {
            this.countryMinimumAgeForSelfConsent.removeEmpty();
        }
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class EmailPlus
    extends Enableable {
        @ExcludeFromDatabaseDataColumn
        public UUID emailTemplateId;
        public int maximumTimeToSendEmailInHours = 48;
        public int minimumTimeToSendEmailInHours = 24;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EmailPlus)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EmailPlus emailPlus = (EmailPlus)o;
            return this.maximumTimeToSendEmailInHours == emailPlus.maximumTimeToSendEmailInHours && this.minimumTimeToSendEmailInHours == emailPlus.minimumTimeToSendEmailInHours && Objects.equals(this.emailTemplateId, emailPlus.emailTemplateId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.emailTemplateId, this.maximumTimeToSendEmailInHours, this.minimumTimeToSendEmailInHours);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

