/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum GrantType {
    authorization_code("authorization_code"),
    implicit("implicit"),
    password("password"),
    client_credentials("client_credentials"),
    refresh_token("refresh_token"),
    unknown("unknown"),
    device_code("urn:ietf:params:oauth:grant-type:device_code");

    private static Map<String, GrantType> nameMap;
    private String grantName;

    private GrantType(String grantName) {
        this.grantName = grantName;
    }

    @JsonCreator
    public static GrantType forValue(String value) {
        GrantType grantType = nameMap.get(value);
        if (grantType != null) {
            return grantType;
        }
        return unknown;
    }

    @JsonValue
    public String grantName() {
        return this.grantName;
    }

    static {
        nameMap = new HashMap<String, GrantType>(GrantType.values().length);
        for (GrantType grantType : GrantType.values()) {
            nameMap.put(grantType.grantName(), grantType);
        }
    }
}

