/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.ApplicationFormConfiguration;
import io.fusionauth.domain.ApplicationRegistrationDeletePolicy;
import io.fusionauth.domain.ApplicationRole;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CanonicalizationMethod;
import io.fusionauth.domain.CleanSpeakConfiguration;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.Requirable;
import io.fusionauth.domain.Tenantable;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.ExcludeFromDatabaseDataColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.oauth2.OAuth2Configuration;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Application
implements Buildable<Application>,
_InternalJSONColumn,
Tenantable {
    public static final UUID FUSIONAUTH_APP_ID = UUID.fromString("3c219e58-ed0e-4b18-ad48-f4f92793ae32");
    public boolean active;
    @InternalJSONColumn
    public AuthenticationTokenConfiguration authenticationTokenConfiguration = new AuthenticationTokenConfiguration();
    @InternalJSONColumn
    public CleanSpeakConfiguration cleanSpeakConfiguration;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public ApplicationEmailConfiguration emailConfiguration = new ApplicationEmailConfiguration();
    @InternalJSONColumn
    public ApplicationFormConfiguration formConfiguration = new ApplicationFormConfiguration();
    public UUID id;
    public ZonedDateTime insertInstant;
    @InternalJSONColumn
    public JWTConfiguration jwtConfiguration = new JWTConfiguration();
    public LambdaConfiguration lambdaConfiguration = new LambdaConfiguration();
    public ZonedDateTime lastUpdateInstant;
    @InternalJSONColumn
    public LoginConfiguration loginConfiguration = new LoginConfiguration();
    public String name;
    @InternalJSONColumn
    public OAuth2Configuration oauthConfiguration = new OAuth2Configuration();
    @InternalJSONColumn
    public PasswordlessConfiguration passwordlessConfiguration = new PasswordlessConfiguration();
    @InternalJSONColumn
    public RegistrationConfiguration registrationConfiguration = new RegistrationConfiguration();
    @InternalJSONColumn
    public ApplicationRegistrationDeletePolicy registrationDeletePolicy = new ApplicationRegistrationDeletePolicy();
    public List<ApplicationRole> roles = new ArrayList<ApplicationRole>();
    @InternalJSONColumn
    public SAMLv2Configuration samlv2Configuration = new SAMLv2Configuration();
    public UUID tenantId;
    public UUID verificationEmailTemplateId;
    @InternalJSONColumn
    public boolean verifyRegistration;

    @JacksonConstructor
    public Application() {
    }

    public Application(String name) {
        this.name = name;
    }

    public Application(UUID id, String name, boolean active, CleanSpeakConfiguration cleanSpeakConfiguration, ApplicationRole ... roles) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.cleanSpeakConfiguration = cleanSpeakConfiguration;
        Collections.addAll(this.roles, roles);
    }

    public Application(UUID id, String name, boolean active, CleanSpeakConfiguration cleanSpeakConfiguration, OAuth2Configuration oAuthConfiguration, ApplicationRole ... roles) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.cleanSpeakConfiguration = cleanSpeakConfiguration;
        this.oauthConfiguration = oAuthConfiguration;
        Collections.addAll(this.roles, roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application that = (Application)o;
        return this.active == that.active && this.verifyRegistration == that.verifyRegistration && Objects.equals(this.authenticationTokenConfiguration, that.authenticationTokenConfiguration) && Objects.equals(this.cleanSpeakConfiguration, that.cleanSpeakConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.formConfiguration, that.formConfiguration) && Objects.equals(this.id, that.id) && Objects.equals(this.jwtConfiguration, that.jwtConfiguration) && Objects.equals(this.lambdaConfiguration, that.lambdaConfiguration) && Objects.equals(this.loginConfiguration, that.loginConfiguration) && Objects.equals(this.name, that.name) && Objects.equals(this.oauthConfiguration, that.oauthConfiguration) && Objects.equals(this.passwordlessConfiguration, that.passwordlessConfiguration) && Objects.equals(this.registrationConfiguration, that.registrationConfiguration) && Objects.equals(this.registrationDeletePolicy, that.registrationDeletePolicy) && Objects.equals(this.roles, that.roles) && Objects.equals(this.samlv2Configuration, that.samlv2Configuration) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.verificationEmailTemplateId, that.verificationEmailTemplateId);
    }

    public ApplicationRole getRole(String name) {
        for (ApplicationRole role : this.roles) {
            if (!role.name.equals(name)) continue;
            return role;
        }
        return null;
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean hasDefaultRole() {
        return this.roles.size() > 0 && this.roles.stream().anyMatch(r -> r.isDefault);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.authenticationTokenConfiguration, this.cleanSpeakConfiguration, this.data, this.id, this.formConfiguration, this.jwtConfiguration, this.lambdaConfiguration, this.loginConfiguration, this.name, this.oauthConfiguration, this.passwordlessConfiguration, this.registrationConfiguration, this.registrationDeletePolicy, this.roles, this.samlv2Configuration, this.insertInstant, this.lastUpdateInstant, this.tenantId, this.verificationEmailTemplateId, this.verifyRegistration);
    }

    public void normalize() {
        this.name = Normalizer.trim(this.name);
        if (this.cleanSpeakConfiguration != null) {
            this.cleanSpeakConfiguration.normalize();
        }
        if (this.oauthConfiguration != null) {
            this.oauthConfiguration.normalize();
        }
        this.jwtConfiguration.refreshTokenRevocationPolicy = null;
        this.roles.forEach(ApplicationRole::normalize);
    }

    public Application secure() {
        if (this.oauthConfiguration != null) {
            this.oauthConfiguration.clientSecret = null;
        }
        return this;
    }

    public Application sortRoles() {
        this.roles.sort(ApplicationRole::compareTo);
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class SAMLv2Configuration
    extends Enableable
    implements Buildable<SAMLv2Configuration> {
        public String audience;
        @JsonMerge(value=OptBoolean.FALSE)
        public List<URI> authorizedRedirectURLs = new ArrayList<URI>();
        public boolean debug;
        @ExcludeFromDatabaseDataColumn
        public UUID defaultVerificationKeyId;
        public String issuer;
        @ExcludeFromDatabaseDataColumn
        public UUID keyId;
        public URI logoutURL;
        public boolean requireSignedRequests;
        public CanonicalizationMethod xmlSignatureC14nMethod = CanonicalizationMethod.exclusive_with_comments;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SAMLv2Configuration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SAMLv2Configuration that = (SAMLv2Configuration)o;
            return Objects.equals(this.audience, that.audience) && Objects.equals(this.authorizedRedirectURLs, that.authorizedRedirectURLs) && Objects.equals(this.debug, that.debug) && Objects.equals(this.defaultVerificationKeyId, that.defaultVerificationKeyId) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.logoutURL, that.logoutURL) && Objects.equals(this.requireSignedRequests, that.requireSignedRequests) && Objects.equals((Object)this.xmlSignatureC14nMethod, (Object)that.xmlSignatureC14nMethod);
        }

        @Deprecated
        public URI getCallbackURL() {
            if (this.authorizedRedirectURLs.isEmpty()) {
                return null;
            }
            return this.authorizedRedirectURLs.get(0);
        }

        @Deprecated
        public void setCallbackURL(URI callbackURL) {
            if (!this.authorizedRedirectURLs.contains(callbackURL)) {
                this.authorizedRedirectURLs.add(callbackURL);
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.audience, this.authorizedRedirectURLs, this.debug, this.defaultVerificationKeyId, this.issuer, this.keyId, this.logoutURL, this.requireSignedRequests, this.xmlSignatureC14nMethod});
        }
    }

    public static class RegistrationConfiguration
    extends Enableable
    implements Buildable<RegistrationConfiguration> {
        public Requirable birthDate = new Requirable();
        public boolean confirmPassword;
        public Requirable firstName = new Requirable();
        public UUID formId;
        public Requirable fullName = new Requirable();
        public Requirable lastName = new Requirable();
        public LoginIdType loginIdType = LoginIdType.email;
        public Requirable middleName = new Requirable();
        public Requirable mobilePhone = new Requirable();
        public RegistrationType type;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegistrationConfiguration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegistrationConfiguration that = (RegistrationConfiguration)o;
            return this.confirmPassword == that.confirmPassword && Objects.equals(this.birthDate, that.birthDate) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.formId, that.formId) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.lastName, that.lastName) && this.loginIdType == that.loginIdType && Objects.equals(this.middleName, that.middleName) && Objects.equals(this.mobilePhone, that.mobilePhone) && this.type == that.type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.birthDate, this.confirmPassword, this.firstName, this.formId, this.fullName, this.lastName, this.loginIdType, this.middleName, this.mobilePhone, this.type});
        }

        public String toString() {
            return ToString.toString((Object)this);
        }

        public static enum RegistrationType {
            basic,
            advanced;

        }

        public static enum LoginIdType {
            email,
            username;

        }
    }

    public static class PasswordlessConfiguration
    extends Enableable {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class LoginConfiguration
    implements Buildable<LoginConfiguration> {
        public boolean allowTokenRefresh;
        public boolean generateRefreshTokens;
        public boolean requireAuthentication = true;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoginConfiguration)) {
                return false;
            }
            LoginConfiguration that = (LoginConfiguration)o;
            return this.requireAuthentication == that.requireAuthentication && this.allowTokenRefresh == that.allowTokenRefresh && this.generateRefreshTokens == that.generateRefreshTokens;
        }

        public int hashCode() {
            return Objects.hash(this.requireAuthentication, this.allowTokenRefresh, this.generateRefreshTokens);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class LambdaConfiguration {
        public UUID accessTokenPopulateId;
        public UUID idTokenPopulateId;
        public UUID samlv2PopulateId;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LambdaConfiguration)) {
                return false;
            }
            LambdaConfiguration that = (LambdaConfiguration)o;
            return Objects.equals(this.accessTokenPopulateId, that.accessTokenPopulateId) && Objects.equals(this.idTokenPopulateId, that.idTokenPopulateId) && Objects.equals(this.samlv2PopulateId, that.samlv2PopulateId);
        }

        public int hashCode() {
            return Objects.hash(this.accessTokenPopulateId, this.idTokenPopulateId, this.samlv2PopulateId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class AuthenticationTokenConfiguration
    extends Enableable {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class ApplicationEmailConfiguration
    implements Buildable<ApplicationEmailConfiguration> {
        public UUID emailVerificationEmailTemplateId;
        public UUID forgotPasswordEmailTemplateId;
        public UUID passwordlessEmailTemplateId;
        public UUID setPasswordEmailTemplateId;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationEmailConfiguration that = (ApplicationEmailConfiguration)o;
            return Objects.equals(this.emailVerificationEmailTemplateId, that.emailVerificationEmailTemplateId) && Objects.equals(this.forgotPasswordEmailTemplateId, that.forgotPasswordEmailTemplateId) && Objects.equals(this.passwordlessEmailTemplateId, that.passwordlessEmailTemplateId) && Objects.equals(this.setPasswordEmailTemplateId, that.setPasswordEmailTemplateId);
        }

        public int hashCode() {
            return Objects.hash(this.emailVerificationEmailTemplateId, this.forgotPasswordEmailTemplateId, this.passwordlessEmailTemplateId, this.setPasswordEmailTemplateId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

