/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.RefreshTokenExpirationPolicy;
import io.fusionauth.domain.RefreshTokenRevocationPolicy;
import io.fusionauth.domain.RefreshTokenUsagePolicy;
import io.fusionauth.domain.internal.annotation.ExcludeFromDatabaseDataColumn;
import java.util.Objects;
import java.util.UUID;

public class JWTConfiguration
extends Enableable
implements Buildable<JWTConfiguration> {
    @ExcludeFromDatabaseDataColumn
    public UUID accessTokenKeyId;
    @ExcludeFromDatabaseDataColumn
    public UUID idTokenKeyId;
    public RefreshTokenExpirationPolicy refreshTokenExpirationPolicy;
    public RefreshTokenRevocationPolicy refreshTokenRevocationPolicy;
    public int refreshTokenTimeToLiveInMinutes;
    public RefreshTokenUsagePolicy refreshTokenUsagePolicy;
    public int timeToLiveInSeconds;

    @JacksonConstructor
    public JWTConfiguration() {
    }

    public JWTConfiguration(JWTConfiguration other) {
        this.accessTokenKeyId = other.accessTokenKeyId;
        this.enabled = other.enabled;
        this.idTokenKeyId = other.idTokenKeyId;
        this.refreshTokenExpirationPolicy = other.refreshTokenExpirationPolicy;
        this.refreshTokenRevocationPolicy = other.refreshTokenRevocationPolicy;
        this.refreshTokenTimeToLiveInMinutes = other.refreshTokenTimeToLiveInMinutes;
        this.refreshTokenUsagePolicy = other.refreshTokenUsagePolicy;
        this.timeToLiveInSeconds = other.timeToLiveInSeconds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWTConfiguration)) {
            return false;
        }
        JWTConfiguration that = (JWTConfiguration)o;
        return super.equals(o) && Objects.equals(this.accessTokenKeyId, that.accessTokenKeyId) && Objects.equals(this.idTokenKeyId, that.idTokenKeyId) && Objects.equals((Object)this.refreshTokenExpirationPolicy, (Object)that.refreshTokenExpirationPolicy) && Objects.equals(this.refreshTokenTimeToLiveInMinutes, that.refreshTokenTimeToLiveInMinutes) && Objects.equals((Object)this.refreshTokenUsagePolicy, (Object)that.refreshTokenUsagePolicy) && Objects.equals(this.timeToLiveInSeconds, that.timeToLiveInSeconds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.accessTokenKeyId, this.idTokenKeyId, this.refreshTokenExpirationPolicy, this.refreshTokenTimeToLiveInMinutes, this.refreshTokenUsagePolicy, this.timeToLiveInSeconds});
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

