/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Objects;
import java.util.UUID;

public class JWTRefreshEvent
extends BaseEvent
implements Buildable<JWTRefreshEvent> {
    public UUID applicationId;
    public String original;
    public String refreshToken;
    public String token;
    public UUID userId;

    @JacksonConstructor
    public JWTRefreshEvent() {
    }

    public JWTRefreshEvent(UUID applicationId, String token, String original, String refreshToken, UUID userId) {
        this.applicationId = applicationId;
        this.token = token;
        this.original = original;
        this.refreshToken = refreshToken;
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWTRefreshEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JWTRefreshEvent that = (JWTRefreshEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.original, that.original) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.token, that.token) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public EventType getType() {
        return EventType.JWTRefresh;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.original, this.refreshToken, this.token, this.userId);
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

