/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CORSConfiguration;
import io.fusionauth.domain.RequiresCORSConfiguration;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.jwks.JSONWebKeyInfoProvider;
import io.fusionauth.domain.provider.AppleApplicationConfiguration;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.util.HTTPMethod;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;

public class AppleIdentityProvider
extends BaseIdentityProvider<AppleApplicationConfiguration>
implements Buildable<AppleIdentityProvider>,
JSONWebKeyInfoProvider,
RequiresCORSConfiguration {
    public static final URI ISSUER = URI.create("https://appleid.apple.com");
    public static final URI JWKS_URI = URI.create("https://appleid.apple.com/auth/keys");
    @InternalJSONColumn
    public String buttonText = "Sign in with Apple";
    public UUID keyId;
    @InternalJSONColumn
    public String scope;
    @InternalJSONColumn
    public String servicesId;
    @InternalJSONColumn
    public String teamId;

    @Override
    @JsonIgnore
    public CORSConfiguration corsConfiguration() {
        return new CORSConfiguration().with(override -> override.allowedMethods.add(HTTPMethod.POST)).with(override -> override.allowedOrigins.add(this.issuer()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppleIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AppleIdentityProvider that = (AppleIdentityProvider)o;
        return Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.scope, that.scope) && Objects.equals(this.servicesId, that.servicesId) && Objects.equals(this.teamId, that.teamId);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.Apple;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buttonText, this.keyId, this.scope, this.servicesId, this.teamId);
    }

    @Override
    public URI issuer() {
        return ISSUER;
    }

    @Override
    public URI jwksURI() {
        return JWKS_URI;
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupButtonText(UUID applicationId) {
        return this.lookup(() -> this.buttonText, () -> this.app(applicationId, (D app) -> app.buttonText));
    }

    public UUID lookupKeyId(UUID applicationId) {
        return this.lookup(() -> this.keyId, () -> this.app(applicationId, (D app) -> app.keyId));
    }

    public String lookupScope(String clientId) {
        return this.lookup(() -> this.scope, () -> this.app(clientId, (D app) -> app.scope));
    }

    public String lookupScope(UUID applicationId) {
        return this.lookup(() -> this.scope, () -> this.app(applicationId, (D app) -> app.scope));
    }

    public String lookupServicesId(String clientId) {
        return this.lookup(() -> this.servicesId, () -> this.app(clientId, (D app) -> app.servicesId));
    }

    public String lookupServicesId(UUID applicationId) {
        return this.lookup(() -> this.servicesId, () -> this.app(applicationId, (D app) -> app.servicesId));
    }

    public String lookupTeamId(String clientId) {
        return this.lookup(() -> this.teamId, () -> this.app(clientId, (D app) -> app.teamId));
    }

    public String lookupTeamId(UUID applicationId) {
        return this.lookup(() -> this.teamId, () -> this.app(applicationId, (D app) -> app.teamId));
    }

    @Override
    public void normalize() {
        super.normalize();
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

