/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.FacebookApplicationConfiguration;
import io.fusionauth.domain.provider.IdentityProviderLoginMethod;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.SupportsPostBindings;
import java.util.Objects;
import java.util.UUID;

public class FacebookIdentityProvider
extends BaseIdentityProvider<FacebookApplicationConfiguration>
implements Buildable<FacebookIdentityProvider>,
SupportsPostBindings {
    @InternalJSONColumn
    public String appId;
    @InternalJSONColumn
    public String buttonText = "Login with Facebook";
    @InternalJSONColumn
    public String client_secret;
    @InternalJSONColumn
    public String fields;
    @InternalJSONColumn
    public IdentityProviderLoginMethod loginMethod;
    @InternalJSONColumn
    public String permissions;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FacebookIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FacebookIdentityProvider that = (FacebookIdentityProvider)o;
        return Objects.equals(this.appId, that.appId) && Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.client_secret, that.client_secret) && Objects.equals(this.fields, that.fields) && this.loginMethod == that.loginMethod && Objects.equals(this.permissions, that.permissions);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.Facebook;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.appId, this.buttonText, this.client_secret, this.fields, this.loginMethod, this.permissions});
    }

    public String lookupAppId(UUID applicationId) {
        return this.lookup(() -> this.appId, () -> this.app(applicationId, (D app) -> app.appId));
    }

    public String lookupAppId(String clientId) {
        return this.lookup(() -> this.appId, () -> this.app(clientId, (D app) -> app.appId));
    }

    public String lookupButtonText(UUID applicationId) {
        return this.lookup(() -> this.buttonText, () -> this.app(applicationId, (D app) -> app.buttonText));
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupClientSecret(UUID applicationId) {
        return this.lookup(() -> this.client_secret, () -> this.app(applicationId, (D app) -> app.client_secret));
    }

    public String lookupFields(UUID applicationId) {
        return this.lookup(() -> this.fields, () -> this.app(applicationId, (D app) -> app.fields));
    }

    public IdentityProviderLoginMethod lookupLoginMethod(String clientId) {
        return this.lookup(() -> this.loginMethod, () -> this.app(clientId, (D app) -> app.loginMethod));
    }

    public String lookupPermissions(UUID applicationId) {
        return this.lookup(() -> this.permissions, () -> this.app(applicationId, (D app) -> app.permissions));
    }

    public String lookupPermissions(String clientId) {
        return this.lookup(() -> this.permissions, () -> this.app(clientId, (D app) -> app.permissions));
    }

    @Override
    public boolean postRequestEnabled() {
        return false;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

