/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CORSConfiguration;
import io.fusionauth.domain.CanonicalizationMethod;
import io.fusionauth.domain.RequiresCORSConfiguration;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.DomainBasedIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.SAMLv2ApplicationConfiguration;
import io.fusionauth.domain.provider.SupportsPostBindings;
import io.fusionauth.domain.util.HTTPMethod;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class SAMLv2IdentityProvider
extends BaseIdentityProvider<SAMLv2ApplicationConfiguration>
implements Buildable<SAMLv2IdentityProvider>,
DomainBasedIdentityProvider,
RequiresCORSConfiguration,
SupportsPostBindings {
    public final Set<String> domains = new HashSet<String>();
    @InternalJSONColumn
    public URI buttonImageURL;
    @InternalJSONColumn
    public String buttonText = "Login with SAML";
    @InternalJSONColumn
    public String emailClaim;
    @InternalJSONColumn
    public URI idpEndpoint;
    @Deprecated
    @InternalJSONColumn
    public String issuer;
    public UUID keyId;
    @InternalJSONColumn
    public String nameIdFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
    @InternalJSONColumn
    public boolean postRequest;
    public UUID requestSigningKeyId;
    @InternalJSONColumn
    public boolean signRequest;
    @InternalJSONColumn
    public String uniqueIdClaim;
    @InternalJSONColumn
    public boolean useNameIdForEmail;
    @InternalJSONColumn
    public String usernameClaim;
    @InternalJSONColumn
    public CanonicalizationMethod xmlSignatureC14nMethod;

    @Override
    @JsonIgnore
    public CORSConfiguration corsConfiguration() {
        return new CORSConfiguration().with(override -> override.allowedMethods.add(HTTPMethod.POST)).with(override -> override.allowedOrigins.add(URI.create(this.idpEndpoint.getScheme() + "://" + this.idpEndpoint.getHost() + (this.idpEndpoint.getPort() == -1 ? "" : ":" + this.idpEndpoint.getPort()))));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMLv2IdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SAMLv2IdentityProvider that = (SAMLv2IdentityProvider)o;
        return this.postRequest == that.postRequest && this.signRequest == that.signRequest && this.useNameIdForEmail == that.useNameIdForEmail && Objects.equals(this.domains, that.domains) && Objects.equals(this.buttonImageURL, that.buttonImageURL) && Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.emailClaim, that.emailClaim) && Objects.equals(this.idpEndpoint, that.idpEndpoint) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.nameIdFormat, that.nameIdFormat) && Objects.equals(this.requestSigningKeyId, that.requestSigningKeyId) && Objects.equals(this.uniqueIdClaim, that.uniqueIdClaim) && Objects.equals(this.usernameClaim, that.usernameClaim) && this.xmlSignatureC14nMethod == that.xmlSignatureC14nMethod;
    }

    @Override
    public Set<String> getDomains() {
        return this.domains;
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.SAMLv2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.domains, this.buttonImageURL, this.buttonText, this.emailClaim, this.idpEndpoint, this.issuer, this.keyId, this.nameIdFormat, this.postRequest, this.requestSigningKeyId, this.signRequest, this.uniqueIdClaim, this.useNameIdForEmail, this.usernameClaim, this.xmlSignatureC14nMethod});
    }

    public URI lookupButtonImageURL(String clientId) {
        return this.lookup(() -> this.buttonImageURL, () -> this.app(clientId, (D app) -> app.buttonImageURL));
    }

    public URI lookupButtonImageURL(UUID applicationId) {
        return this.lookup(() -> this.buttonImageURL, () -> this.app(applicationId, (D app) -> app.buttonImageURL));
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupButtonText(UUID applicationId) {
        return this.lookup(() -> this.buttonText, () -> this.app(applicationId, (D app) -> app.buttonText));
    }

    @Override
    public void normalize() {
        super.normalize();
        this.normalizeDomains();
    }

    @Override
    public boolean postRequestEnabled() {
        return this.postRequest;
    }

    public SAMLv2IdentityProvider secure() {
        this.domains.clear();
        this.emailClaim = null;
        this.usernameClaim = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

