/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.search;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.EventLogType;
import io.fusionauth.domain.search.BaseSearchCriteria;
import java.time.ZonedDateTime;

public class EventLogSearchCriteria
extends BaseSearchCriteria {
    public ZonedDateTime end;
    public String message;
    public ZonedDateTime start;
    public EventLogType type;

    @JacksonConstructor
    public EventLogSearchCriteria() {
        this.orderBy = this.defaultOrderBy();
    }

    public EventLogSearchCriteria(String message, EventLogType type, ZonedDateTime start, ZonedDateTime end, int startRow, int numberOfResults, String orderBy) {
        this.end = end;
        this.message = message;
        this.numberOfResults = numberOfResults;
        this.orderBy = orderBy;
        this.start = start;
        this.startRow = startRow;
        this.type = type;
    }

    public EventLogSearchCriteria(int startRow, int numberOfResults) {
        this.numberOfResults = numberOfResults;
        this.orderBy = this.defaultOrderBy();
        this.startRow = startRow;
    }

    @Override
    public void prepare() {
        this.secure();
        if (this.orderBy == null) {
            this.orderBy = this.defaultOrderBy();
        }
        this.message = EventLogSearchCriteria.toSearchString(this.message);
    }

    @Override
    protected String defaultOrderBy() {
        return "insert_instant DESC, id DESC";
    }
}

