/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderLinkingStrategy;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.SupportsPostBindings;
import io.fusionauth.domain.provider.XboxApplicationConfiguration;
import java.util.Objects;
import java.util.UUID;

public class XboxIdentityProvider
extends BaseIdentityProvider<XboxApplicationConfiguration>
implements Buildable<XboxIdentityProvider>,
SupportsPostBindings {
    @InternalJSONColumn
    public String buttonText = "Login with Xbox";
    @InternalJSONColumn
    public String client_id;
    @InternalJSONColumn
    public String client_secret;
    @InternalJSONColumn
    public String scope;

    public XboxIdentityProvider() {
        this.linkingStrategy = IdentityProviderLinkingStrategy.CreatePendingLink;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XboxIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XboxIdentityProvider that = (XboxIdentityProvider)o;
        return Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.client_id, that.client_id) && Objects.equals(this.client_secret, that.client_secret) && Objects.equals(this.scope, that.scope);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.Xbox;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buttonText, this.client_id, this.client_secret, this.scope);
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupClientId(UUID applicationId) {
        return this.lookup(() -> this.client_id, () -> this.app(applicationId, (D app) -> app.client_id));
    }

    public String lookupClientId(String clientId) {
        return this.lookup(() -> this.client_id, () -> this.app(clientId, (D app) -> app.client_id));
    }

    public String lookupClientSecret(UUID applicationId) {
        return this.lookup(() -> this.client_secret, () -> this.app(applicationId, (D app) -> app.client_secret));
    }

    public String lookupScope(String clientId) {
        return this.lookup(() -> this.scope, () -> this.app(clientId, (D app) -> app.scope));
    }

    @Override
    public boolean postRequestEnabled() {
        return false;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

