/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.connector.ConnectorType;
import io.fusionauth.domain.connector.FusionAuthConnectorConfiguration;
import io.fusionauth.domain.connector.GenericConnectorConfiguration;
import io.fusionauth.domain.connector.LDAPConnectorConfiguration;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ConnectorJacksonHelper {
    public static ConnectorType extractType(DeserializationContext ctxt, JsonParser p, JsonNode connectorNode) throws IOException {
        JsonNode node = connectorNode.at("/type");
        String type = node.asText(ConnectorType.Generic.name());
        ConnectorType connectorType = ConnectorType.safeValueOf(type);
        if (connectorType == null) {
            String sorted = Arrays.stream(ConnectorType.values()).map(Enum::name).sorted().collect(Collectors.joining(", "));
            return (ConnectorType)((Object)ctxt.handleUnexpectedToken(BaseConnectorConfiguration.class, node.asToken(), p, "Expected the type field to be one of [" + sorted + "], but found [" + node.asText() + "]", new Object[0]));
        }
        return connectorType;
    }

    public static BaseConnectorConfiguration newConnector(ConnectorType type) {
        switch (type) {
            case FusionAuth: {
                return new FusionAuthConnectorConfiguration();
            }
            case Generic: {
                return new GenericConnectorConfiguration();
            }
            case LDAP: {
                return new LDAPConnectorConfiguration();
            }
        }
        throw new IllegalStateException("Unexpected type [" + (Object)((Object)type) + "]. This is a FusionAuth bug, someone forgot to add a case statement for a new type.");
    }
}

