/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.domain.api.ConnectorResponse;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.connector.ConnectorType;
import io.fusionauth.json.ConnectorJacksonHelper;
import java.io.IOException;
import java.util.ArrayList;

public class ConnectorResponseDeserializer
extends StdDeserializer<ConnectorResponse> {
    public ConnectorResponseDeserializer() {
        super(ConnectorResponse.class);
    }

    public ConnectorResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new ConnectorResponse());
    }

    public ConnectorResponse deserialize(JsonParser p, DeserializationContext ctxt, ConnectorResponse resp) throws IOException {
        JsonNode connectorNodes;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode connectorNode = node.at("/connector");
        if (connectorNode != null) {
            ConnectorType connectorType = ConnectorJacksonHelper.extractType(ctxt, p, connectorNode);
            resp.connector = ConnectorJacksonHelper.newConnector(connectorType);
            ((ObjectMapper)p.getCodec()).readerForUpdating((Object)resp.connector).readValue(connectorNode);
        }
        if ((connectorNodes = node.at("/connectors")) != null && connectorNodes.isArray()) {
            resp.connectors = new ArrayList<BaseConnectorConfiguration>();
            for (JsonNode connector : connectorNodes) {
                ConnectorType connectorType = ConnectorJacksonHelper.extractType(ctxt, p, connector);
                BaseConnectorConfiguration baseConnectorConfiguration = ConnectorJacksonHelper.newConnector(connectorType);
                ((ObjectMapper)p.getCodec()).readerForUpdating((Object)baseConnectorConfiguration).readValue(connector);
                resp.connectors.add(baseConnectorConfiguration);
            }
        }
        return resp;
    }
}

