/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.RateLimitedRequestConfiguration;
import io.fusionauth.domain.RateLimitedRequestType;
import java.util.Objects;

public class TenantRateLimitConfiguration
implements Buildable<TenantRateLimitConfiguration> {
    public RateLimitedRequestConfiguration failedLogin = new RateLimitedRequestConfiguration(5, 60);
    public RateLimitedRequestConfiguration forgotPassword = new RateLimitedRequestConfiguration(5, 60);
    public RateLimitedRequestConfiguration sendEmailVerification = new RateLimitedRequestConfiguration(5, 60);
    public RateLimitedRequestConfiguration sendPasswordless = new RateLimitedRequestConfiguration(5, 60);
    public RateLimitedRequestConfiguration sendRegistrationVerification = new RateLimitedRequestConfiguration(5, 60);
    public RateLimitedRequestConfiguration sendTwoFactor = new RateLimitedRequestConfiguration(5, 60);

    @JacksonConstructor
    public TenantRateLimitConfiguration() {
    }

    public TenantRateLimitConfiguration(TenantRateLimitConfiguration other) {
        this.failedLogin = new RateLimitedRequestConfiguration(other.failedLogin);
        this.forgotPassword = new RateLimitedRequestConfiguration(other.forgotPassword);
        this.sendEmailVerification = new RateLimitedRequestConfiguration(other.sendEmailVerification);
        this.sendPasswordless = new RateLimitedRequestConfiguration(other.sendPasswordless);
        this.sendRegistrationVerification = new RateLimitedRequestConfiguration(other.sendRegistrationVerification);
        this.sendTwoFactor = new RateLimitedRequestConfiguration(other.sendTwoFactor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantRateLimitConfiguration that = (TenantRateLimitConfiguration)o;
        return Objects.equals(this.failedLogin, that.failedLogin) && Objects.equals(this.forgotPassword, that.forgotPassword) && Objects.equals(this.sendEmailVerification, that.sendEmailVerification) && Objects.equals(this.sendPasswordless, that.sendPasswordless) && Objects.equals(this.sendRegistrationVerification, that.sendRegistrationVerification) && Objects.equals(this.sendTwoFactor, that.sendTwoFactor);
    }

    @JsonIgnore
    public RateLimitedRequestConfiguration getConfiguration(RateLimitedRequestType type) {
        switch (type) {
            case FailedLogin: {
                return this.failedLogin;
            }
            case ForgotPassword: {
                return this.forgotPassword;
            }
            case SendEmailVerification: {
                return this.sendEmailVerification;
            }
            case SendPasswordless: {
                return this.sendPasswordless;
            }
            case SendRegistrationVerification: {
                return this.sendRegistrationVerification;
            }
            case SendTwoFactor: {
                return this.sendTwoFactor;
            }
        }
        throw new IllegalArgumentException("Unexpected request type [" + (Object)((Object)type) + "].");
    }

    public int hashCode() {
        return Objects.hash(this.failedLogin, this.forgotPassword, this.sendEmailVerification, this.sendPasswordless, this.sendRegistrationVerification, this.sendTwoFactor);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

