/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class JWTPublicKeyUpdateEvent
extends BaseEvent
implements Buildable<JWTPublicKeyUpdateEvent> {
    public final Set<UUID> applicationIds;

    @JacksonConstructor
    public JWTPublicKeyUpdateEvent() {
        this.applicationIds = new HashSet<UUID>(0);
    }

    public JWTPublicKeyUpdateEvent(EventInfo info, UUID applicationId) {
        super(info);
        this.applicationIds = new HashSet<UUID>();
        this.applicationIds.add(applicationId);
    }

    public JWTPublicKeyUpdateEvent(EventInfo info, Set<UUID> applicationIds) {
        super(info);
        this.applicationIds = new HashSet<UUID>(applicationIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWTPublicKeyUpdateEvent that = (JWTPublicKeyUpdateEvent)o;
        return super.equals(o) && Objects.equals(this.applicationIds, that.applicationIds);
    }

    @Override
    public EventType getType() {
        return EventType.JWTPublicKeyUpdate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationIds);
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

