/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool;

import io.github.kloping.MySpringTool.PartUtils;
import io.github.kloping.MySpringTool.annotations.CommentScan;
import io.github.kloping.MySpringTool.entity.interfaces.Runner;
import io.github.kloping.MySpringTool.exceptions.NoRunException;
import io.github.kloping.MySpringTool.h1.impl.ExtensionImpl0;
import io.github.kloping.MySpringTool.h1.impl.LoggerImpl;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.common.Public;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;

public final class StarterApplication {
    public static Logger logger = new LoggerImpl();
    public static ClassLoader SCAN_LOADER = StarterApplication.class.getClassLoader();
    private static int poolSize = 20;
    private static long waitTime = 12000L;
    private static Class<?> mainKey = Long.class;
    private static String scanPath;
    private static boolean inited;
    public static final List<Runnable> STARTED_RUNNABLE;
    public static final List<Runnable> PRE_SCAN_RUNNABLE;
    public static final List<Runnable> POST_SCAN_RUNNABLE;
    private static Set<String> fileSet;

    public static void setPoolSize(int poolSize) {
        StarterApplication.poolSize = poolSize;
    }

    public static void setWaitTime(long waitTime) {
        StarterApplication.waitTime = waitTime;
    }

    public static void run(Class<?> cla) {
        if (!cla.isAnnotationPresent(CommentScan.class)) {
            try {
                throw new NoRunException("this class must must has @CommentScan");
            }
            catch (Throwable throwable) {
                System.exit(0);
                throw throwable;
            }
        }
        CommentScan scan = cla.getAnnotation(CommentScan.class);
        scanPath = PartUtils.filter(scan.path(), cla);
        PartUtils.check(scanPath);
        StarterApplication.loadConf();
        StarterApplication.work(cla);
        StarterApplication.workAfter();
        StarterApplication.startAfter();
    }

    private static void startAfter() {
        for (Runnable runnable : STARTED_RUNNABLE) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setMainKey(Class<?> cla) {
        mainKey = cla;
    }

    public static void setAccessTypes(Class<?> ... classes) {
        StarterApplication.getInstance().argsManager.setArgsType(classes);
    }

    public static synchronized int executeMethod(Object ... objects) {
        return StarterApplication.getInstance().queueExecutor.queueExecute(objects[0], objects);
    }

    public static void setAllAfter(Runner runner) {
        StarterApplication.getInstance().queueExecutor.setAfter(runner);
    }

    public static void setAllBefore(Runner runner) {
        StarterApplication.getInstance().queueExecutor.setBefore(runner);
    }

    private static void workAfter() {
        String format;
        Integer l = StarterApplication.getInstance().contextManager.getContextEntity(Integer.class, "log.level");
        if (l != null) {
            logger.setLogLevel(l);
        }
        if ((format = StarterApplication.getInstance().contextManager.getContextEntity(String.class, "out.format")) != null) {
            logger.setFormat(new SimpleDateFormat(format));
        }
        StarterApplication.getInstance().getContextManager().append(logger);
    }

    private static void loadConf() {
        for (String path : fileSet) {
            StarterApplication.getInstance().configFileManager.load(path);
        }
    }

    private static void reloadConf() {
        for (String path : fileSet) {
            StarterApplication.getInstance().configFileManager.load(path);
        }
    }

    public static Set<String> addConfFile(File file) {
        fileSet.add(file.getAbsolutePath());
        return fileSet;
    }

    public static Set<String> addConfFile(String file) {
        fileSet.add(file);
        return fileSet;
    }

    private static void work(Class<?> main) {
        try {
            Object startClass = StarterApplication.getInstance().getInstanceCrater().create(main, StarterApplication.getInstance().contextManager);
            StarterApplication.getInstance().getContextManager().append(startClass);
            StarterApplication.getInstance().getClassManager().add(main);
            StarterApplication.preScan();
            for (Class<?> aClass : StarterApplication.getInstance().getPackageScanner().scan(main, SCAN_LOADER, scanPath)) {
                StarterApplication.getInstance().getClassManager().add(aClass);
            }
            StarterApplication.postScan();
            logger.info("start sptool success");
        }
        catch (Throwable e) {
            logger.error("There is an exception=>" + e + " at " + PartUtils.getExceptionLine(e));
            e.printStackTrace();
        }
    }

    private static void postScan() {
        final CountDownLatch cdl = new CountDownLatch(POST_SCAN_RUNNABLE.size());
        for (final Runnable runnable : POST_SCAN_RUNNABLE) {
            Public.EXECUTOR_SERVICE.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void preScan() {
        ExtensionImpl0.INSTANCE = new ExtensionImpl0(StarterApplication.getInstance());
        for (Runnable runnable : PRE_SCAN_RUNNABLE) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                logger.error("There is an exception=>" + e + " at " + PartUtils.getExceptionLine(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static io.github.kloping.MySpringTool.Setting getInstance() {
        Class<StarterApplication> clazz = StarterApplication.class;
        synchronized (StarterApplication.class) {
            if (!inited) {
                Setting.INSTANCE = new io.github.kloping.MySpringTool.Setting(){

                    @Override
                    public List<Runnable> getSTARTED_RUNNABLE() {
                        return STARTED_RUNNABLE;
                    }

                    @Override
                    public List<Runnable> getPRE_SCAN_RUNNABLE() {
                        return PRE_SCAN_RUNNABLE;
                    }

                    @Override
                    public List<Runnable> getPOST_SCAN_RUNNABLE() {
                        return POST_SCAN_RUNNABLE;
                    }
                };
                Setting.INSTANCE.defaultInit(mainKey, poolSize, waitTime);
                inited = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Setting.INSTANCE;
        }
    }

    static {
        inited = false;
        STARTED_RUNNABLE = new LinkedList<Runnable>();
        PRE_SCAN_RUNNABLE = new LinkedList<Runnable>();
        POST_SCAN_RUNNABLE = new LinkedList<Runnable>();
        fileSet = new CopyOnWriteArraySet<String>();
    }

    public static final class Setting {
        public static io.github.kloping.MySpringTool.Setting INSTANCE;
    }
}

