/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl;

import io.github.kloping.MySpringTool.Setting;
import io.github.kloping.MySpringTool.interfaces.Extension;
import io.github.kloping.MySpringTool.interfaces.Logger;
import java.util.ArrayList;
import java.util.List;

public class ExtensionImpl0
implements Extension {
    public static final List<String> EXTENSIONS = new ArrayList<String>();
    private Setting setting;
    public static ExtensionImpl0 INSTANCE;

    public ExtensionImpl0(Setting setting) {
        this.setting = setting;
        this.load();
    }

    private void load() {
        Logger logger = this.setting.getContextManager().getContextEntity(Logger.class);
        for (String extension : this.getExtensions()) {
            Extension.ExtensionRunnable runnable = null;
            try {
                Class<?> cla = Class.forName(extension);
                Object o = this.setting.getInstanceCrater().create(cla, this.setting.getContextManager());
                this.setting.getContextManager().append(o, extension);
                runnable = (Extension.ExtensionRunnable)o;
                runnable.setSetting(this.setting);
                runnable.run();
                if (logger == null) continue;
                logger.info(runnable.getName() + " extension load");
            }
            catch (ClassNotFoundException cla) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (logger == null) continue;
                logger.info(extension + " extension load failed");
            }
        }
    }

    @Override
    public List<String> getExtensions() {
        return EXTENSIONS;
    }

    static {
        EXTENSIONS.add("io.github.kloping.little_web.WebExtension");
        EXTENSIONS.add("io.github.kloping.spt.SptRedis");
        INSTANCE = null;
    }
}

