/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.MySpringTool.h1.impl.component;

import io.github.kloping.MySpringTool.entity.interfaces.Runner;
import io.github.kloping.MySpringTool.interfaces.Executor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorImpl
implements Executor {
    private int size = 20;
    private long waitTime = 5000L;
    private ExecutorService threads;
    private Runner runner1;
    private Runner runner2;

    public void setBefore(Runner runner) {
        this.runner1 = runner;
    }

    public void setAfter(Runner runner) {
        this.runner2 = runner;
    }

    private void init() {
        this.threads = new ThreadPoolExecutor(this.size, this.size, this.waitTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.size));
    }

    public ExecutorImpl(int size, long waitTime) {
        this.size = size;
        this.waitTime = waitTime;
        this.init();
    }

    public ExecutorImpl(long waitTime) {
        this.waitTime = waitTime;
        this.init();
    }

    @Override
    public Future execute(Object this_, Method method, Object ... objects) throws InvocationTargetException, IllegalAccessException {
        this.threads.submit(() -> {
            try {
                if (this.runner1 != null) {
                    this.runner1.run(this_, objects);
                }
                Object o = method.invoke(this_, objects);
                if (this.runner2 != null) {
                    this.runner2.run(this_, objects);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        return null;
    }
}

